/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.xml.XmlBundle;

public class WebOpenInAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        ActionGroup group = WebOpenInAction.getGroup();
        AnAction onlyAction = ActionGroupUtil.getSingleActiveAction((ActionGroup)group, (AnActionEvent)e, (boolean)LaterInvocator.isInModalContext());
        if (onlyAction != null) {
            onlyAction.actionPerformed(e);
            return;
        }
        JBPopupFactory.getInstance().createActionGroupPopup(XmlBundle.message((String)"open_in.list.popup.title", (Object[])new Object[0]), group, dataContext, JBPopupFactory.ActionSelectionAid.MNEMONICS, false).showInBestPositionFor(dataContext);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        AnAction onlyAction = ActionGroupUtil.getSingleActiveAction((ActionGroup)WebOpenInAction.getGroup(), (AnActionEvent)event, (boolean)LaterInvocator.isInModalContext());
        presentation.setText(onlyAction != null ? XmlBundle.message((String)"open_in.list.prefix", (Object[])new Object[0]) + " " + onlyAction.getTemplatePresentation().getText() : XmlBundle.message((String)"open_in.list.popup.title", (Object[])new Object[0]));
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(!ActionGroupUtil.isGroupEmpty((ActionGroup)WebOpenInAction.getGroup(), (AnActionEvent)event, (boolean)LaterInvocator.isInModalContext()));
    }

    private static ActionGroup getGroup() {
        return (ActionGroup)ActionManager.getInstance().getAction("OpenInBrowserEditorContextBarGroupAction");
    }
}

