/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.pics;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.w3c.jigsaw.pics.InvalidLabelException;
import org.w3c.jigsaw.pics.LabelInterface;
import org.w3c.jigsaw.pics.LabelServiceInterface;
import org.w3c.jigsaw.pics.PICS;
import org.w3c.jigsaw.pics.SampleLabel;
import org.w3c.jigsaw.pics.SampleLabelBureau;
import org.w3c.jigsaw.pics.UnknownServiceException;

public class SampleLabelService
implements LabelServiceInterface {
    File directory = null;
    String name = null;

    private final File getDirectory() {
        return this.directory;
    }

    private String slashify(String string) {
        String string2 = System.getProperty("file.separator");
        if (string2.equals("/")) {
            return string;
        }
        if (string2.length() != 1) {
            throw new RuntimeException(this.getClass().getName() + " invalid separator length !");
        }
        return string.replace('/', '\\');
    }

    public File filify(URL uRL, boolean bl) {
        File file = null;
        file = new File(this.getDirectory(), uRL.getProtocol());
        file = new File(file, uRL.getHost());
        if (uRL.getPort() != 80 && uRL.getPort() != -1) {
            file = new File(file, new Integer(uRL.getPort()).toString());
        }
        if (uRL.getFile() != null && !uRL.getFile().equals("/")) {
            String string = bl ? uRL.getFile().substring(1) + ".gen" : uRL.getFile().substring(1);
            file = new File(file, this.slashify(string));
        } else if (bl) {
            file = new File(file.getParent(), file.getName() + ".gen");
        }
        if (PICS.debug()) {
            System.out.println("Label for " + uRL + " in [" + file + "]");
        }
        return file;
    }

    public String getName() {
        return this.name;
    }

    public void dump(StringBuffer stringBuffer, int n) {
        stringBuffer.append(" \"" + this.getName() + "\"");
    }

    public LabelInterface getSpecificLabel(URL uRL) {
        File file = this.filify(uRL, false);
        if (file.exists()) {
            SampleLabel sampleLabel = null;
            try {
                sampleLabel = new SampleLabel(file);
            }
            catch (InvalidLabelException invalidLabelException) {
                return null;
            }
            return sampleLabel;
        }
        return null;
    }

    public LabelInterface getGenericLabel(URL uRL) {
        try {
            while (true) {
                Object object;
                File file;
                if ((file = this.filify(uRL, true)).exists()) {
                    object = null;
                    try {
                        object = new SampleLabel(file);
                    }
                    catch (InvalidLabelException invalidLabelException) {
                        return null;
                    }
                    return object;
                }
                object = uRL.getFile();
                if (object == null || ((String)object).equals("/")) {
                    return null;
                }
                String string = uRL.getFile();
                if (string.length() - 1 == string.lastIndexOf("/")) {
                    string = string.substring(0, string.length() - 2);
                }
                if ((string = string.substring(0, string.lastIndexOf("/"))).length() == 0) {
                    string = "/";
                }
                uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public LabelInterface[] getTreeLabels(URL uRL) {
        File file = this.filify(uRL, false);
        if (!file.isDirectory()) {
            return null;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return null;
        }
        LabelInterface labelInterface = this.getGenericLabel(uRL);
        Vector<LabelInterface> vector = new Vector<LabelInterface>(stringArray.length);
        if (labelInterface != null) {
            vector.addElement(labelInterface);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            SampleLabel sampleLabel = null;
            try {
                sampleLabel = new SampleLabel(new File(file, stringArray[i]));
            }
            catch (InvalidLabelException invalidLabelException) {
                sampleLabel = null;
            }
            if (sampleLabel == null) continue;
            vector.addElement(sampleLabel);
        }
        if (vector.size() > 0) {
            Object[] objectArray = new SampleLabel[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public LabelInterface[] getGenericTreeLabels(URL uRL) {
        File file = this.filify(uRL, false);
        if (!file.isDirectory()) {
            return null;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return null;
        }
        LabelInterface labelInterface = this.getGenericLabel(uRL);
        Vector<LabelInterface> vector = new Vector<LabelInterface>(stringArray.length);
        if (labelInterface != null) {
            vector.addElement(labelInterface);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".gen")) continue;
            SampleLabel sampleLabel = null;
            try {
                sampleLabel = new SampleLabel(new File(file, stringArray[i]));
            }
            catch (InvalidLabelException invalidLabelException) {
                sampleLabel = null;
            }
            if (sampleLabel == null) continue;
            vector.addElement(sampleLabel);
        }
        if (vector.size() > 0) {
            Object[] objectArray = new SampleLabel[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public SampleLabelService(SampleLabelBureau sampleLabelBureau, String string) throws UnknownServiceException {
        this.name = string;
        try {
            this.directory = new File(sampleLabelBureau.getIdentifier());
            this.directory = this.filify(new URL(string), false);
        }
        catch (MalformedURLException malformedURLException) {
            throw new UnknownServiceException(string);
        }
        if (PICS.debug()) {
            System.out.println("LabelService for " + string + " is in " + this.directory.getAbsolutePath());
        }
        if (!this.directory.exists() || !this.directory.isDirectory()) {
            throw new UnknownServiceException(string);
        }
    }
}

