/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.ui.GithubCredentialsPanel;
import org.jetbrains.plugins.github.util.AuthLevel;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubLoginDialog
extends DialogWrapper {
    private static final Logger LOG = GithubUtil.LOG;
    private final GithubCredentialsPanel myCredentialsPanel;
    @NotNull
    private final Project myProject;
    @NotNull
    private final AuthLevel myAuthLevel;
    private GithubAuthData myAuthData;
    private boolean mySavePassword;

    public GithubLoginDialog(@NotNull Project project, @NotNull GithubAuthData oldAuthData, @NotNull AuthLevel authLevel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/ui/GithubLoginDialog", "<init>"));
        }
        if (oldAuthData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldAuthData", "org/jetbrains/plugins/github/ui/GithubLoginDialog", "<init>"));
        }
        if (authLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authLevel", "org/jetbrains/plugins/github/ui/GithubLoginDialog", "<init>"));
        }
        super(project, true);
        this.myProject = project;
        this.myAuthLevel = authLevel;
        this.myCredentialsPanel = new GithubCredentialsPanel(project);
        this.myCredentialsPanel.setTestButtonVisible(false);
        this.myCredentialsPanel.setHost(oldAuthData.getHost());
        this.myCredentialsPanel.setAuthType(oldAuthData.getAuthType());
        GithubAuthData.BasicAuth basicAuth = oldAuthData.getBasicAuth();
        if (basicAuth != null) {
            this.myCredentialsPanel.setLogin(basicAuth.getLogin());
        }
        if (authLevel.getHost() != null) {
            this.myCredentialsPanel.lockHost(authLevel.getHost());
        }
        if (authLevel.getAuthType() != null) {
            this.myCredentialsPanel.lockAuthType(authLevel.getAuthType());
        }
        if (!authLevel.isOnetime()) {
            this.setDoNotAskOption(new MyRememberPasswordOption());
        }
        this.setTitle("Login to GitHub");
        this.setOKButtonText("Login");
        this.init();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubLoginDialog", "createActions"));
        }
        return actionArray;
    }

    protected JComponent createCenterPanel() {
        return this.myCredentialsPanel;
    }

    protected String getHelpId() {
        return "login_to_github";
    }

    protected void doOKAction() {
        GithubAuthDataHolder authHolder = new GithubAuthDataHolder(this.myCredentialsPanel.getAuthData());
        try {
            GithubUtil.computeValueInModalIO(this.myProject, "Access to GitHub", indicator -> GithubUtil.checkAuthData(this.myProject, authHolder, indicator));
            this.myAuthData = authHolder.getAuthData();
            super.doOKAction();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            this.setErrorText("Can't login: " + GithubUtil.getErrorTextFromException(e), this.myCredentialsPanel);
        }
    }

    public boolean isSavePasswordSelected() {
        return this.mySavePassword;
    }

    @NotNull
    public GithubAuthData getAuthData() {
        if (this.myAuthData == null) {
            throw new IllegalStateException("AuthData is not set");
        }
        GithubAuthData githubAuthData = this.myAuthData;
        if (githubAuthData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubLoginDialog", "getAuthData"));
        }
        return githubAuthData;
    }

    private class MyRememberPasswordOption
    implements DialogWrapper.DoNotAskOption {
        private MyRememberPasswordOption() {
        }

        public boolean isToBeShown() {
            return !GithubSettings.getInstance().isSavePassword();
        }

        public void setToBeShown(boolean toBeShown, int exitCode) {
            GithubLoginDialog.this.mySavePassword = !toBeShown;
            GithubSettings.getInstance().setSavePassword(!toBeShown);
        }

        public boolean canBeHidden() {
            return GithubSettings.getInstance().isSavePasswordMakesSense();
        }

        public boolean shouldSaveOptionsOnCancel() {
            return false;
        }

        @NotNull
        public String getDoNotShowMessage() {
            if ("Save credentials" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubLoginDialog$MyRememberPasswordOption", "getDoNotShowMessage"));
            }
            return "Save credentials";
        }
    }
}

