/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodeJs;

import com.intellij.javascript.debugger.DebuggableFileFinderImpl;
import com.intellij.javascript.debugger.LocalFileSystemFileFinder;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.nodeJs.NodeJSFileFinderKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/nodeJs/NodeJSFileFinder;", "Lcom/intellij/javascript/debugger/LocalFileSystemFileFinder;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "coreLibraryManager", "Lcom/intellij/javascript/nodejs/library/NodeJsCoreLibraryManager;", "Lorg/jetbrains/annotations/NotNull;", "httpFinder", "Lcom/intellij/javascript/debugger/DebuggableFileFinderImpl;", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "Lcom/intellij/util/Url;", "getRemoteUrls", "", "file", "ChromeConnector"})
public final class NodeJSFileFinder
extends LocalFileSystemFileFinder {
    private final NodeJsCoreLibraryManager coreLibraryManager;
    private final DebuggableFileFinderImpl httpFinder;

    @Nullable
    public VirtualFile findFile(@NotNull Url url, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (NodeJSFileFinderKt.isModuleName(url)) {
            VirtualFile virtualFile = this.coreLibraryManager.findCoreModuleFileByName(StringUtil.trimEnd((String)url.getPath(), (String)".js"));
            if (virtualFile != null) {
                VirtualFile virtualFile2;
                VirtualFile it = virtualFile2 = virtualFile;
                return it;
            }
        }
        if (!url.isInLocalFileSystem()) {
            VirtualFile virtualFile = this.httpFinder.findFile(url, project);
            if (virtualFile != null) {
                VirtualFile virtualFile3;
                VirtualFile it = virtualFile3 = virtualFile;
                return it;
            }
        }
        return super.findFile(url, project);
    }

    @NotNull
    public List<Url> getRemoteUrls(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.coreLibraryManager.isCoreModuleLibraryFile(file) ? CollectionsKt.listOf((Object)Urls.newLocalFileUrl((String)file.getName())) : super.getRemoteUrls(file);
    }

    public NodeJSFileFinder(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(false, 1, null);
        this.coreLibraryManager = NodeJsCoreLibraryManager.getInstance((Project)project);
        this.httpFinder = new DebuggableFileFinderImpl(project, null);
    }
}

