/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.util.Function;
import com.intellij.util.Url;
import com.intellij.util.UrlImpl;
import com.intellij.util.Urls;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptManagerBaseEx;
import org.jetbrains.debugger.ScriptManagerKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.v8.HotSwapScriptManager;
import org.jetbrains.v8.liveEditProtocol.ScriptLiveChangeResult;
import org.jetbrains.wip.WipAsyncCallFrame;
import org.jetbrains.wip.WipCallFrame;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipFunction;
import org.jetbrains.wip.WipNetworkManager;
import org.jetbrains.wip.WipScript;
import org.jetbrains.wip.WipScriptManager;
import org.jetbrains.wip.WipSuspendContextManager;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.WipWorker;
import org.jetbrains.wip.protocol.debugger.CallFrameValue;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.ScriptParsedEventData;
import org.jetbrains.wip.protocol.debugger.SetScriptSourceResult;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J#\u0010\u0013\u001a\u0015\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0010\u00a2\u0006\u0002\b\u00162\u0006\u0010\u000b\u001a\u00020\u0002H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\u0016\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nJ&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\nH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/wip/WipScriptManager;", "Lorg/jetbrains/debugger/ScriptManagerBaseEx;", "Lorg/jetbrains/wip/WipScript;", "Lorg/jetbrains/v8/HotSwapScriptManager;", "vm", "Lorg/jetbrains/wip/WipVm;", "commandProcessor", "Lorg/jetbrains/wip/WipCommandProcessor;", "(Lorg/jetbrains/wip/WipVm;Lorg/jetbrains/wip/WipCommandProcessor;)V", "containsScript", "", "script", "Lorg/jetbrains/debugger/Script;", "getScript", "frame", "Lorg/jetbrains/debugger/CallFrame;", "Lorg/jetbrains/concurrency/Promise;", "function", "Lorg/jetbrains/debugger/values/FunctionValue;", "loadScriptSource", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "rawUrlToOurUrl", "Lcom/intellij/util/Url;", "rawUrl", "scriptParsed", "data", "Lorg/jetbrains/wip/protocol/debugger/ScriptParsedEventData;", "isFromWorker", "setSourceOnRemote", "Lorg/jetbrains/v8/liveEditProtocol/ScriptLiveChangeResult;", "newSource", "", "preview", "wip-backend"})
public final class WipScriptManager
extends ScriptManagerBaseEx<WipScript>
implements HotSwapScriptManager {
    private final WipVm vm;
    private final WipCommandProcessor commandProcessor;

    public boolean containsScript(@NotNull Script script) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        return script instanceof WipScript && this.getIdToScript().containsKey(((WipScript)script).id);
    }

    @NotNull
    protected Promise<String> loadScriptSource(@NotNull WipScript script) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)script), (String)"script");
        String string = script.id;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"script.id");
        return this.commandProcessor.send((Request)DebuggerKt.GetScriptSource(string)).then((Function)loadScriptSource.1.INSTANCE);
    }

    @Override
    @NotNull
    public Promise<ScriptLiveChangeResult> setSourceOnRemote(@NotNull Script script, @NotNull CharSequence newSource, boolean preview) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Intrinsics.checkParameterIsNotNull((Object)newSource, (String)"newSource");
        String string = ((WipScript)script).id;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(script as WipScript).id");
        Promise promise2 = this.commandProcessor.send((Request)DebuggerKt.SetScriptSource(string, newSource, preview)).then(new Function<T, SUB_RESULT>(this, preview){
            final /* synthetic */ WipScriptManager this$0;
            final /* synthetic */ boolean $preview;

            @NotNull
            public final setSourceOnRemote.1 fun(SetScriptSourceResult it) {
                List<CallFrameValue> callFrames;
                if (!this.$preview && !UtilKt.isNullOrEmpty((Collection)(callFrames = it.getCallFrames()))) {
                    WipSuspendContextManager wipSuspendContextManager = WipScriptManager.access$getVm$p(this.this$0).getSuspendContextManager();
                    List<CallFrameValue> list = callFrames;
                    if (list == null) {
                        Intrinsics.throwNpe();
                    }
                    wipSuspendContextManager.updateStackTrace(list);
                }
                return new ScriptLiveChangeResult(){
                    @NotNull
                    private final ScriptLiveChangeResult.ChangeStatus status;
                    @Nullable
                    private final String statusExplanation;

                    @NotNull
                    public ScriptLiveChangeResult.ChangeStatus getStatus() {
                        return this.status;
                    }

                    @Nullable
                    public String getStatusExplanation() {
                        return this.statusExplanation;
                    }

                    public void doRecommended() {
                    }
                    {
                        this.status = ScriptLiveChangeResult.ChangeStatus.UNCHANGED;
                    }
                };
            }
            {
                this.this$0 = wipScriptManager;
                this.$preview = bl;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"commandProcessor.send(Se\u2026      }\n        }\n      }");
        return promise2;
    }

    @NotNull
    public Promise<Script> getScript(@NotNull FunctionValue function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        Promise promise2 = function.resolve().then(new Function<T, SUB_RESULT>(this){
            final /* synthetic */ WipScriptManager this$0;

            @Nullable
            public final WipScript fun(FunctionValue it) {
                FunctionValue functionValue = it;
                if (functionValue == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.wip.WipFunction");
                }
                return (WipScript)this.this$0.findScriptById(((WipFunction)functionValue).getScriptId());
            }
            {
                this.this$0 = wipScriptManager;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"function.resolve()\n    .\u2026 WipFunction).scriptId) }");
        return promise2;
    }

    @Nullable
    public Script getScript(@NotNull CallFrame frame) {
        String scriptId;
        Object scriptManager;
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        if (frame instanceof WipCallFrame) {
            WipWorker worker = ((WipValueManager)((WipCallFrame)frame).getEvaluateContext().getValueManager()).getWorker();
            Object object = worker;
            if (object == null || (object = ((WipWorker)object).getScriptManager$wip_backend()) == null) {
                object = this;
            }
            scriptManager = object;
            String string = ((WipCallFrame)frame).getScriptId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            scriptId = string;
        } else if (frame instanceof WipAsyncCallFrame) {
            scriptManager = this;
            scriptId = ((WipAsyncCallFrame)frame).getScriptId();
        } else {
            return null;
        }
        return (Script)scriptManager.findScriptById(scriptId);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Url rawUrlToOurUrl(@NotNull String rawUrl) {
        Url url;
        String absoluteUrl;
        String documentUrl;
        int lastSlash;
        Url tabUrl;
        Intrinsics.checkParameterIsNotNull((Object)rawUrl, (String)"rawUrl");
        if (StringsKt.startsWith$default((String)rawUrl, (String)"extensions::", (boolean)false, (int)2, null)) {
            return (Url)new UrlImpl(rawUrl);
        }
        if (StringsKt.startsWith$default((String)rawUrl, (String)"dart:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)rawUrl, (String)"package:", (boolean)false, (int)2, null)) {
            Url url2 = Urls.newFromIdea((CharSequence)rawUrl);
            Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"Urls.newFromIdea(rawUrl)");
            return url2;
        }
        Url url3 = Urls.parse((String)rawUrl, (boolean)true);
        if (url3 != null) {
            return url3;
        }
        Url url4 = tabUrl = this.vm.getCurrentUrl();
        CharSequence charSequence = url4 != null ? url4.getAuthority() : null;
        if (charSequence == null || charSequence.length() == 0) {
            Url url5 = Urls.newLocalFileUrl((String)rawUrl);
            Intrinsics.checkExpressionValueIsNotNull((Object)url5, (String)"Urls.newLocalFileUrl(rawUrl)");
            return url5;
        }
        Url url6 = tabUrl;
        if (url6 == null) {
            Intrinsics.throwNpe();
        }
        if ((lastSlash = StringsKt.lastIndexOf$default((CharSequence)(documentUrl = url6.trimParameters().toExternalForm()), (char)'/', (int)0, (boolean)false, (int)6, null)) == -1) {
            absoluteUrl = documentUrl + "/" + rawUrl;
        } else {
            String string = documentUrl;
            int n = 0;
            int n2 = lastSlash + 1;
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string4 = string3;
            absoluteUrl = stringBuilder.append(string4).append(rawUrl).toString();
        }
        Url parsedUrl = Urls.parseEncoded((String)absoluteUrl);
        if (parsedUrl != null) {
            WipNetworkManager wipNetworkManager = this.vm.getNetworkManager();
            String string = parsedUrl.trimParameters().toExternalForm();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parsedUrl.trimParameters().toExternalForm()");
            if (wipNetworkManager.wasRequested(string)) {
                url = parsedUrl;
                return url;
            }
        }
        url = (Url)new UrlImpl(rawUrl);
        return url;
    }

    @NotNull
    public final Script scriptParsed(@NotNull ScriptParsedEventData data, boolean isFromWorker) {
        Url url;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String id = data.scriptId();
        CharSequence charSequence = data.url();
        Url url2 = url = charSequence == null || charSequence.length() == 0 ? Urls.newUri((String)ScriptManagerKt.VM_SCHEME, (String)id) : this.rawUrlToOurUrl(data.url());
        WipScript script = isFromWorker ? WipScript.newWorkerScript(id, url) : new WipScript(id, data.isContentScript() ? Script.Type.EXTENSION : Script.Type.NORMAL, url, data.getStartLine(), data.getStartColumn(), data.getEndLine());
        WipScript existingScript = this.getIdToScript().putIfAbsent(id, script);
        if (existingScript != null) {
            return (Script)existingScript;
        }
        if (url.getScheme() != null || !StringsKt.startsWith$default((String)data.url(), (String)"extensions::", (boolean)false, (int)2, null)) {
            this.vm.getDebugListener().scriptAdded((Vm)this.vm, (Script)script, data.getSourceMapURL());
        }
        WipScript wipScript = script;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)wipScript), (String)"script");
        return (Script)wipScript;
    }

    public WipScriptManager(@NotNull WipVm vm, @NotNull WipCommandProcessor commandProcessor2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)((Object)commandProcessor2), (String)"commandProcessor");
        this.vm = vm;
        this.commandProcessor = commandProcessor2;
    }

    public /* synthetic */ WipScriptManager(WipVm wipVm, WipCommandProcessor wipCommandProcessor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            wipCommandProcessor = wipVm.getCommandProcessor();
        }
        this(wipVm, wipCommandProcessor);
    }

    @NotNull
    public static final /* synthetic */ WipVm access$getVm$p(WipScriptManager $this) {
        return $this.vm;
    }
}

