/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.util.Function;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextManagerBase;
import org.jetbrains.jsonProtocol.EventMap;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.EvaluateHack;
import org.jetbrains.wip.JSExecutionStackSuspendContext;
import org.jetbrains.wip.WipCallFrame;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipSuspendContext;
import org.jetbrains.wip.WipSuspendContextManager$WhenMappings;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.WipWorkerCommandProcessor;
import org.jetbrains.wip.protocol.ProtocolResponseReader;
import org.jetbrains.wip.protocol.WipRequest;
import org.jetbrains.wip.protocol.debugger.CallFrameValue;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.PausedEventData;
import org.jetbrains.wip.protocol.debugger.RestartFrameResult;
import org.jetbrains.wip.protocol.debugger.ResumedEventData;
import org.jetbrains.wip.protocol.page.PageKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001c\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0002J\u0012\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0016H\u0002J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020&0\u001eH\u0014J\u0014\u0010)\u001a\u00020\u00122\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+H\u0016J\u0018\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020.2\b\u0010'\u001a\u0004\u0018\u00010\u0016J\b\u0010/\u001a\u00020&H\u0002J+\u00100\u001a\u0015\u0012\f\u0012\n 1*\u0004\u0018\u00010\u00120\u00120\u001e\u00a2\u0006\u0002\b22\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u0002H\u0014J\u0010\u00104\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0016J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020&062\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u00107\u001a\u00020&2\b\u00108\u001a\u0004\u0018\u00010\u0016H\u0016J\u0014\u00109\u001a\u00020&2\n\u0010:\u001a\u0006\u0012\u0002\b\u00030+H\u0016J\u0014\u0010;\u001a\u00020&2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0013R)\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00170\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/wip/WipSuspendContextManager;", "Lorg/jetbrains/debugger/SuspendContextManagerBase;", "Lorg/jetbrains/wip/WipSuspendContext;", "Lorg/jetbrains/wip/WipCallFrame;", "vm", "Lorg/jetbrains/wip/WipVm;", "(Lorg/jetbrains/wip/WipVm;)V", "debugListener", "Lorg/jetbrains/debugger/DebugEventListener;", "getDebugListener", "()Lorg/jetbrains/debugger/DebugEventListener;", "evaluateHack", "Lorg/jetbrains/wip/EvaluateHack;", "getEvaluateHack$wip_backend", "()Lorg/jetbrains/wip/EvaluateHack;", "hasOverlay", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isRestartFrameSupported", "", "()Z", "threadSuspendContexts", "", "", "Lorg/jetbrains/wip/JSExecutionStackSuspendContext;", "getThreadSuspendContexts", "()Ljava/util/Map;", "canRestartFrame", "callFrame", "Lorg/jetbrains/debugger/CallFrame;", "continueVm", "Lorg/jetbrains/concurrency/Promise;", "stepAction", "Lorg/jetbrains/debugger/StepAction;", "stepCount", "", "currentContextCommandProcessor", "Lorg/jetbrains/wip/WipCommandProcessor;", "dismissContext", "", "workerId", "doSuspend", "isContextObsolete", "context", "Lorg/jetbrains/debugger/SuspendContext;", "pausedEventDataReceived", "it", "Lorg/jetbrains/wip/protocol/debugger/PausedEventData;", "removeOverlay", "restartFrame", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "currentContext", "resumedEventDataReceived", "sdkStepToProtocolStep", "Lorg/jetbrains/wip/protocol/WipRequest;", "setOverlayMessage", "message", "updateContext", "newContext", "updateStackTrace", "callFrames", "", "Lorg/jetbrains/wip/protocol/debugger/CallFrameValue;", "wip-backend"})
public final class WipSuspendContextManager
extends SuspendContextManagerBase<WipSuspendContext, WipCallFrame> {
    private final AtomicBoolean hasOverlay;
    @NotNull
    private final EvaluateHack evaluateHack;
    private final boolean isRestartFrameSupported = true;
    @NotNull
    private final DebugEventListener debugListener;
    @NotNull
    private final Map<String, JSExecutionStackSuspendContext<WipSuspendContext, WipCallFrame>> threadSuspendContexts;
    private final WipVm vm;

    @NotNull
    public final EvaluateHack getEvaluateHack$wip_backend() {
        return this.evaluateHack;
    }

    public boolean isRestartFrameSupported() {
        return this.isRestartFrameSupported;
    }

    @NotNull
    protected DebugEventListener getDebugListener() {
        return this.debugListener;
    }

    @NotNull
    public final Map<String, JSExecutionStackSuspendContext<WipSuspendContext, WipCallFrame>> getThreadSuspendContexts() {
        return this.threadSuspendContexts;
    }

    public boolean isContextObsolete(@NotNull SuspendContext<?> context) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        for (JSExecutionStackSuspendContext<WipSuspendContext, WipCallFrame> stack : this.threadSuspendContexts.values()) {
            if (stack.getSuspendContext() != context) continue;
            return false;
        }
        return super.isContextObsolete(context);
    }

    public final void pausedEventDataReceived(@NotNull PausedEventData it, @Nullable String workerId) {
        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
        AsyncPromise callback = this.getSuspendCallback().getAndSet(null);
        WipSuspendContext context = new WipSuspendContext(this.vm, workerId, it, callback != null);
        if (this.getContextRef().get() == null) {
            this.setContext(context);
        }
        AsyncPromise asyncPromise = callback;
        if (asyncPromise != null) {
            asyncPromise.setResult(null);
        }
        this.vm.getDebugListener().suspended((SuspendContext)context);
    }

    public final void resumedEventDataReceived(@Nullable String workerId) {
        if (workerId == null) {
            this.removeOverlay();
        }
        this.dismissContext(workerId);
    }

    private final void dismissContext(String workerId) {
        boolean currentThreadResumed;
        Object object;
        WipSuspendContext context = (WipSuspendContext)((Object)this.getContextRef().get());
        String string = workerId;
        if (string == null) {
            string = "";
        }
        if ((object = this.threadSuspendContexts.remove(string)) == null || (object = ((JSExecutionStackSuspendContext)object).getSuspendContext()) == null) {
            object = context;
        }
        if (object == null) {
            return;
        }
        Object resumed = object;
        boolean bl = currentThreadResumed = context != null && Intrinsics.areEqual((Object)((Object)context), resumed);
        if (currentThreadResumed) {
            this.getContextRef().set(null);
        }
        ((WipSuspendContext)((Object)resumed)).getValueManager().markObsolete();
        if (currentThreadResumed) {
            this.getDebugListener().resumed();
        }
    }

    @NotNull
    protected Promise<Boolean> restartFrame(@NotNull WipCallFrame callFrame, @NotNull WipSuspendContext currentContext) {
        Intrinsics.checkParameterIsNotNull((Object)callFrame, (String)"callFrame");
        Intrinsics.checkParameterIsNotNull((Object)((Object)currentContext), (String)"currentContext");
        WipCommandProcessor wipCommandProcessor = currentContext.getValueManager().getCommandProcessor();
        String string = callFrame.getId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return wipCommandProcessor.send((Request)DebuggerKt.RestartFrame(string)).thenAsync(new Function<T, Promise<SUB_RESULT>>(this, currentContext){
            final /* synthetic */ WipSuspendContextManager this$0;
            final /* synthetic */ WipSuspendContext $currentContext;

            @NotNull
            public final Promise<Boolean> fun(RestartFrameResult it) {
                Promise promise2;
                if (Intrinsics.areEqual((Object)this.this$0.getContext(), (Object)((Object)this.$currentContext)) ^ true) {
                    promise2 = Promises.resolvedPromise((Object)false);
                } else {
                    this.$currentContext.setFrames(it.callFrames(), null);
                    promise2 = Promises.resolvedPromise((Object)false);
                }
                return promise2;
            }
            {
                this.this$0 = wipSuspendContextManager;
                this.$currentContext = wipSuspendContext;
            }
        });
    }

    public boolean canRestartFrame(@NotNull CallFrame callFrame) {
        Intrinsics.checkParameterIsNotNull((Object)callFrame, (String)"callFrame");
        return this.vm.getScriptManager().getScript(callFrame) != null;
    }

    public final void updateStackTrace(@NotNull List<? extends CallFrameValue> callFrames) {
        block0: {
            Intrinsics.checkParameterIsNotNull(callFrames, (String)"callFrames");
            WipSuspendContext wipSuspendContext = (WipSuspendContext)((Object)this.getContextRef().get());
            if (wipSuspendContext == null) break block0;
            wipSuspendContext.setFrames(callFrames, null);
        }
    }

    @NotNull
    protected Promise<Unit> doSuspend() {
        return this.currentContextCommandProcessor().send((Request)DebuggerKt.Pause());
    }

    public void setOverlayMessage(@Nullable String message) {
        if (!this.vm.isNode() && !(this.currentContextCommandProcessor() instanceof WipWorkerCommandProcessor) && this.hasOverlay.compareAndSet(false, true)) {
            this.vm.getCommandProcessor().send((Request)PageKt.ConfigureOverlay(false, message));
        }
    }

    @NotNull
    public Promise<?> continueVm(@NotNull StepAction stepAction, int stepCount) {
        Intrinsics.checkParameterIsNotNull((Object)stepAction, (String)"stepAction");
        ((WipSuspendContext)this.getContextOrFail()).getValueManager().markObsolete();
        this.removeOverlay();
        return this.currentContextCommandProcessor().send((Request)this.sdkStepToProtocolStep(stepAction));
    }

    private final void removeOverlay() {
        if (!this.vm.isNode() && this.hasOverlay.compareAndSet(true, false)) {
            this.vm.getCommandProcessor().send((Request)PageKt.ConfigureOverlay(false, null));
        }
    }

    private final WipRequest<Unit> sdkStepToProtocolStep(StepAction stepAction) {
        WipRequest<Unit> wipRequest;
        switch (WipSuspendContextManager$WhenMappings.$EnumSwitchMapping$0[stepAction.ordinal()]) {
            case 1: {
                wipRequest = DebuggerKt.Resume();
                break;
            }
            case 2: {
                wipRequest = DebuggerKt.StepInto();
                break;
            }
            case 3: {
                wipRequest = DebuggerKt.StepOut();
                break;
            }
            case 4: {
                wipRequest = DebuggerKt.StepOver();
                break;
            }
            default: {
                throw (Throwable)new RuntimeException();
            }
        }
        return wipRequest;
    }

    private final WipCommandProcessor currentContextCommandProcessor() {
        WipSuspendContext currentContext = (WipSuspendContext)((Object)this.getContextRef().get());
        return currentContext != null ? currentContext.getValueManager().getCommandProcessor() : this.vm.getCommandProcessor();
    }

    public void updateContext(@NotNull SuspendContext<?> newContext) {
        Intrinsics.checkParameterIsNotNull(newContext, (String)"newContext");
        if (newContext instanceof WipSuspendContext) {
            this.getContextRef().set(newContext);
        }
    }

    public WipSuspendContextManager(@NotNull WipVm vm) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        this.hasOverlay = new AtomicBoolean();
        this.evaluateHack = new EvaluateHack(this.vm);
        this.isRestartFrameSupported = true;
        this.debugListener = this.vm.getDebugListener();
        Map map = Collections.synchronizedMap(new LinkedHashMap());
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"Collections.synchronized\u2026ontext, WipCallFrame>>())");
        this.threadSuspendContexts = map;
        EventMap<ProtocolResponseReader> eventMap = this.vm.getCommandProcessor().getEventMap();
        eventMap.add((EventType)PausedEventData.TYPE, (Function1)new Function1<PausedEventData, Unit>(){

            public final void invoke(@NotNull PausedEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.pausedEventDataReceived(it, null);
            }
        });
        eventMap.add((EventType)ResumedEventData.TYPE, (Function1)new Function1<ResumedEventData, Unit>(){

            public final void invoke(@Nullable ResumedEventData it) {
                this.resumedEventDataReceived(null);
            }
        });
    }
}

