/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.jetbrains.debugger.wip.BrowserChromeDebugProcess;
import com.jetbrains.debugger.wip.BrowserChromeDebugProcessKt;
import com.jetbrains.liveEdit.update.UpdateConfiguration;
import com.jetbrains.liveEdit.update.UpdateConfigurationProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipVm;

final class ChromiumUpdateConfigurationProvider
extends UpdateConfigurationProvider {
    private static final UpdateConfiguration UPDATE_CONFIGURATION = new UpdateConfiguration(){

        @Override
        public void restart(@NotNull XDebugProcess debugProcess) {
            if (debugProcess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/debugger/wip/ChromiumUpdateConfigurationProvider$1", "restart"));
            }
            AppUIUtil.invokeOnEdt(() -> {
                if (debugProcess == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/debugger/wip/ChromiumUpdateConfigurationProvider$1", "lambda$restart$0"));
                }
                WipVm vm = (WipVm)((BrowserChromeDebugProcess)debugProcess).getMainVm();
                if (vm != null) {
                    FileDocumentManager.getInstance().saveAllDocuments();
                    BrowserChromeDebugProcessKt.reloadPage((WipCommandProcessor)vm.getCommandProcessor());
                }
            });
        }
    };

    ChromiumUpdateConfigurationProvider() {
    }

    @Override
    @Nullable
    public UpdateConfiguration getConfiguration(@NotNull XDebugProcess debugProcess) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/debugger/wip/ChromiumUpdateConfigurationProvider", "getConfiguration"));
        }
        return debugProcess instanceof BrowserChromeDebugProcess ? UPDATE_CONFIGURATION : null;
    }

    @Override
    public boolean isSupported(@NotNull RunProfile runProfile) {
        if (runProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runProfile", "com/jetbrains/debugger/wip/ChromiumUpdateConfigurationProvider", "isSupported"));
        }
        return runProfile instanceof JavaScriptDebugConfiguration;
    }
}

