/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.debugger.wip.BrowserChromeDebugProcess;
import com.jetbrains.debugger.wip.extension.JbWipVm;
import com.jetbrains.debugger.wip.extension.RemoteDebugger;
import com.jetbrains.liveEdit.ActiveVmIterator;
import com.jetbrains.liveEdit.ActiveVmIterator2;
import com.jetbrains.liveEdit.ApplicationInspector;
import com.jetbrains.liveEdit.ApplicationInspectorImpl;
import com.jetbrains.liveEdit.UpdatePolicy;
import com.jetbrains.liveEdit.update.ApplicationUpdaterKt;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.DebugProcessImpl;
import org.jetbrains.debugger.Vm;
import org.jetbrains.wip.WipVm;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a>\u0010\u0014\u001a0\u0012\u000e\b\u0001\u0012\n \u0017*\u0004\u0018\u00010\u00160\u0016 \u0017*\u0015\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u0018\u00a2\u0006\u0002\b\u00020\u0015\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001ay\u0010\u0019\u001a\u00020\u0006\"\f\b\u0000\u0010\u001a*\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001d2K\u0010\u001e\u001aG\u0012\u0013\u0012\u0011H\u001a\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b($\u0012\u0013\u0012\u00110%\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020\u00060\u001fH\u0002\"\u0016\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006'"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "doHighlight", "", "selector", "", "selectorSubject", "Lcom/jetbrains/liveEdit/ApplicationInspector$SelectorSubject;", "remoteDebugger", "Lcom/jetbrains/debugger/wip/extension/RemoteDebugger;", "getActiveJbVmIterator", "", "Lcom/jetbrains/debugger/wip/extension/JbWipVm;", "project", "Lcom/intellij/openapi/project/Project;", "getActiveWipVmIterator", "Lorg/jetbrains/wip/WipVm;", "getBrowserChromeDebugProcesses", "", "Lcom/jetbrains/debugger/wip/BrowserChromeDebugProcess;", "kotlin.jvm.PlatformType", "", "processDebugProcesses", "T", "Lorg/jetbrains/debugger/DebugProcessImpl;", "aClass", "Lkotlin/reflect/KClass;", "consumer", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "debugProcess", "Lorg/jetbrains/debugger/Vm;", "vm", "Lcom/jetbrains/liveEdit/UpdatePolicy;", "policy", "LiveEdit"})
public final class ApplicationInspectorImplKt {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ApplicationInspectorImpl.class);

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    private static final List<? extends BrowserChromeDebugProcess> getBrowserChromeDebugProcesses(Project project) {
        return XDebuggerManager.getInstance((Project)project).getDebugProcesses(BrowserChromeDebugProcess.class);
    }

    private static final void doHighlight(CharSequence selector, ApplicationInspector.SelectorSubject selectorSubject, RemoteDebugger remoteDebugger) {
        remoteDebugger.sendInspectorCommand("Dom", "highlightElement", new Object[]{remoteDebugger.getTabId(), selector, selectorSubject.ordinal()});
    }

    private static final Iterator<JbWipVm> getActiveJbVmIterator(Project project) {
        Iterator iterator;
        if (project.isDisposed()) {
            EmptyIterator emptyIterator = EmptyIterator.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)emptyIterator, (String)"EmptyIterator.getInstance<JbWipVm>()");
            return (Iterator)emptyIterator;
        }
        List<? extends BrowserChromeDebugProcess> processes = ApplicationInspectorImplKt.getBrowserChromeDebugProcesses(project);
        if (processes.isEmpty()) {
            EmptyIterator emptyIterator = EmptyIterator.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)emptyIterator, (String)"EmptyIterator.getInstance<JbWipVm>()");
            iterator = (Iterator)emptyIterator;
        } else {
            List<? extends BrowserChromeDebugProcess> list = processes;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"processes");
            iterator = (Iterator)((Object)new ActiveVmIterator(list));
        }
        return iterator;
    }

    private static final Iterator<WipVm> getActiveWipVmIterator(Project project) {
        Iterator iterator;
        if (project.isDisposed()) {
            EmptyIterator emptyIterator = EmptyIterator.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)emptyIterator, (String)"EmptyIterator.getInstance<WipVm>()");
            return (Iterator)emptyIterator;
        }
        List<? extends BrowserChromeDebugProcess> processes = ApplicationInspectorImplKt.getBrowserChromeDebugProcesses(project);
        if (processes.isEmpty()) {
            EmptyIterator emptyIterator = EmptyIterator.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)emptyIterator, (String)"EmptyIterator.getInstance<WipVm>()");
            iterator = (Iterator)emptyIterator;
        } else {
            List<? extends BrowserChromeDebugProcess> list = processes;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"processes");
            iterator = (Iterator)((Object)new ActiveVmIterator2(list));
        }
        return iterator;
    }

    private static final <T extends DebugProcessImpl<?>> void processDebugProcesses(Project project, KClass<T> aClass, Function3<? super T, ? super Vm, ? super UpdatePolicy, Unit> consumer) {
        for (DebugProcessImpl debugProcess : XDebuggerManager.getInstance((Project)project).getDebugProcesses(JvmClassMappingKt.getJavaClass(aClass))) {
            Vm vm;
            if (debugProcess.getMainVm() == null) {
                continue;
            }
            DebugProcessImpl debugProcessImpl = debugProcess;
            Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"debugProcess");
            UpdatePolicy policy = ApplicationUpdaterKt.getUpdatePolicy((XDebugProcess)debugProcessImpl);
            if (Intrinsics.areEqual((Object)((Object)policy), (Object)((Object)UpdatePolicy.DISABLED))) continue;
            DebugProcessImpl debugProcessImpl2 = debugProcess;
            Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl2, (String)"debugProcess");
            UpdatePolicy updatePolicy = policy;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)updatePolicy), (String)"policy");
            consumer.invoke((Object)debugProcessImpl2, (Object)vm, (Object)updatePolicy);
        }
    }

    public static final /* synthetic */ void access$processDebugProcesses(@NotNull Project project, @NotNull KClass aClass, @NotNull Function3 consumer) {
        ApplicationInspectorImplKt.processDebugProcesses(project, aClass, consumer);
    }

    @NotNull
    public static final /* synthetic */ Iterator access$getActiveJbVmIterator(@NotNull Project project) {
        return ApplicationInspectorImplKt.getActiveJbVmIterator(project);
    }

    @NotNull
    public static final /* synthetic */ List access$getBrowserChromeDebugProcesses(@NotNull Project project) {
        return ApplicationInspectorImplKt.getBrowserChromeDebugProcesses(project);
    }

    @NotNull
    public static final /* synthetic */ Iterator access$getActiveWipVmIterator(@NotNull Project project) {
        return ApplicationInspectorImplKt.getActiveWipVmIterator(project);
    }

    public static final /* synthetic */ void access$doHighlight(@NotNull CharSequence selector, @NotNull ApplicationInspector.SelectorSubject selectorSubject, @NotNull RemoteDebugger remoteDebugger) {
        ApplicationInspectorImplKt.doHighlight(selector, selectorSubject, remoteDebugger);
    }
}

