/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Alarm;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.jetbrains.liveEdit.ApplicationInspector;
import com.jetbrains.liveEdit.ExternalCompilerBean;
import com.jetbrains.liveEdit.FileBasedSynchronizer;
import com.jetbrains.liveEdit.LiveEditManager;
import com.jetbrains.liveEdit.PageReloader;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExternalCompilerBackedFileBasedSynchronizer
extends FileBasedSynchronizer {
    private static final ExtensionPointName<Processor<List<VirtualFile>>> EP_NAME = ExtensionPointName.create((String)"com.jetbrains.liveEdit.compilerInvoker");
    private Alarm refreshAlarm;

    @Override
    public boolean canHandle(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/jetbrains/liveEdit/ExternalCompilerBackedFileBasedSynchronizer", "canHandle"));
        }
        return ExternalCompilerBackedFileBasedSynchronizer.doCanHandle(fileType);
    }

    private static boolean doCanHandle(FileType fileType) {
        return ExternalCompilerBean.get(fileType) != null;
    }

    @Override
    protected void sync(@NotNull List<PsiFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/liveEdit/ExternalCompilerBackedFileBasedSynchronizer", "sync"));
        }
        boolean hasInterpreters = false;
        List filesToCompile = null;
        for (PsiFile file : files) {
            VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
            ExternalCompilerBean externalCompiler = ExternalCompilerBean.get(virtualFile.getFileType());
            assert (externalCompiler != null);
            if (externalCompiler.interpreter) {
                hasInterpreters = true;
                break;
            }
            if (filesToCompile == null) {
                filesToCompile = new SmartList();
            }
            filesToCompile.add(virtualFile);
        }
        List<Project> projects = ExternalCompilerBackedFileBasedSynchronizer.filesToProjects(files);
        boolean finalHasInterpreters = hasInterpreters;
        List finalFilesToCompile = filesToCompile;
        PageReloader.save(files, this.getIsPsiFileModifiedOrContainsErrorCondition(), () -> {
            if (finalHasInterpreters) {
                for (Project project : projects) {
                    ApplicationInspector.getInstance().reloadPages(project);
                }
            }
            if (finalFilesToCompile != null) {
                for (Processor compilerInvoker : (Processor[])EP_NAME.getExtensions()) {
                    if (!compilerInvoker.process((Object)finalFilesToCompile)) continue;
                    return;
                }
                if (this.refreshAlarm == null) {
                    this.refreshAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)ApplicationManager.getApplication());
                }
                this.refreshAlarm.cancelAllRequests();
                this.refreshAlarm.addRequest(ExternalCompilerBackedFileBasedSynchronizer.createRefreshTask(projects), 1000);
            }
        });
    }

    private static Runnable createRefreshTask(List<Project> projects) {
        return () -> {
            for (Project project : projects) {
                if (project.isDisposed()) continue;
                VirtualFile baseDir = project.getBaseDir();
                assert (baseDir != null);
                baseDir.refresh(false, true);
            }
        };
    }

    static final class FileWatcherIsCustom
    implements PairProcessor<VirtualFile, Project> {
        FileWatcherIsCustom() {
        }

        public boolean process(@NotNull VirtualFile file, @NotNull Project project) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/ExternalCompilerBackedFileBasedSynchronizer$FileWatcherIsCustom", "process"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/ExternalCompilerBackedFileBasedSynchronizer$FileWatcherIsCustom", "process"));
            }
            return LiveEditManager.getInstance().isOperable() && ExternalCompilerBackedFileBasedSynchronizer.doCanHandle(file.getFileType());
        }
    }
}

