/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.text.ImmutableCharSequence;
import com.jetbrains.liveEdit.PsiSynchronizer;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileBasedSynchronizer
extends PsiSynchronizer {
    protected static final Logger LOG = Logger.getInstance(FileBasedSynchronizer.class);
    private final Set<PsiElement> elements = new THashSet();
    private final Set<PsiElement> incorrectElements = Collections.newSetFromMap(new WeakHashMap());
    private Condition<List<PsiFile>> isPsiFileModifiedOrContainsError;

    @NotNull
    static List<Project> filesToProjects(@NotNull List<PsiFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/liveEdit/FileBasedSynchronizer", "filesToProjects"));
        }
        SmartList projects = new SmartList();
        for (PsiFile file : files) {
            Project project = file.isValid() ? file.getProject() : null;
            if (project == null || project.isDisposed() || projects.contains(project)) continue;
            projects.add(project);
        }
        SmartList smartList = projects;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/FileBasedSynchronizer", "filesToProjects"));
        }
        return smartList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CharSequence getFileTextIfValidAndRemoveRelatedPendingElements(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/liveEdit/FileBasedSynchronizer", "getFileTextIfValidAndRemoveRelatedPendingElements"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Set<PsiElement> set = this.elements;
        synchronized (set) {
            if (this.containsErrors(psiFile)) {
                return null;
            }
            if (!this.elements.isEmpty()) {
                Iterator<PsiElement> iterator = this.elements.iterator();
                while (iterator.hasNext()) {
                    PsiElement element = iterator.next();
                    if (element.isValid() && element.getContainingFile() != psiFile) continue;
                    iterator.remove();
                }
            }
        }
        return FileBasedSynchronizer.getChars(psiFile);
    }

    @NotNull
    public static CharSequence getChars(@NotNull PsiFile psiFile) {
        String lineSeparator;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/liveEdit/FileBasedSynchronizer", "getChars"));
        }
        FileViewProvider viewProvider = psiFile.getViewProvider();
        Document document = viewProvider.getDocument();
        LOG.assertTrue(document != null);
        try {
            lineSeparator = FileDocumentManagerImpl.getLineSeparator((Document)document, (VirtualFile)viewProvider.getVirtualFile());
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            lineSeparator = "\n";
        }
        CharSequence value = viewProvider.getContents();
        if (lineSeparator.equals("\n")) {
            CharSequence charSequence = value instanceof ImmutableCharSequence ? value : value.toString();
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/FileBasedSynchronizer", "getChars"));
            }
            return charSequence;
        }
        CharSequence result = StringUtilRt.convertLineSeparators((CharSequence)value, (String)lineSeparator);
        CharSequence charSequence = result == value && !(value instanceof ImmutableCharSequence) ? result.toString() : result;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/FileBasedSynchronizer", "getChars"));
        }
        return charSequence;
    }

    @NotNull
    Condition<List<PsiFile>> getIsPsiFileModifiedOrContainsErrorCondition() {
        if (this.isPsiFileModifiedOrContainsError == null) {
            this.isPsiFileModifiedOrContainsError = files -> {
                Set<PsiElement> set = this.elements;
                synchronized (set) {
                    for (PsiFile file : files) {
                        if (!this.containsErrors(file)) continue;
                        return false;
                    }
                    Iterator<PsiElement> iterator = this.elements.iterator();
                    while (iterator.hasNext()) {
                        PsiElement element = iterator.next();
                        if (element.isValid() && !files.contains(element.getContainingFile())) continue;
                        iterator.remove();
                    }
                }
                return true;
            };
        }
        Condition<List<PsiFile>> condition = this.isPsiFileModifiedOrContainsError;
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/FileBasedSynchronizer", "getIsPsiFileModifiedOrContainsErrorCondition"));
        }
        return condition;
    }

    private boolean containsErrors(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/liveEdit/FileBasedSynchronizer", "containsErrors"));
        }
        if (this.incorrectElements.isEmpty()) {
            return false;
        }
        Iterator<PsiElement> iterator = this.incorrectElements.iterator();
        while (iterator.hasNext()) {
            PsiElement element = iterator.next();
            if (!element.isValid() || !PsiTreeUtil.hasErrorElements((PsiElement)element)) {
                iterator.remove();
                continue;
            }
            if (element.getContainingFile() != psiFile) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<VirtualFile> getIncorrectFiles() {
        Set<PsiElement> set = this.elements;
        synchronized (set) {
            if (this.incorrectElements.isEmpty()) {
                List<VirtualFile> list = Collections.emptyList();
                // MONITOREXIT @DISABLED, blocks:[4, 14] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/FileBasedSynchronizer", "getIncorrectFiles"));
                }
                return list;
            }
        }
        List files = null;
        AccessToken token = ReadAction.start();
        try {
            Set<PsiElement> set2 = this.elements;
            synchronized (set2) {
                Iterator<PsiElement> iterator = this.incorrectElements.iterator();
                while (iterator.hasNext()) {
                    PsiElement element = iterator.next();
                    if (!element.isValid() || !PsiTreeUtil.hasErrorElements((PsiElement)element)) {
                        iterator.remove();
                        continue;
                    }
                    VirtualFile file = element.getContainingFile().getVirtualFile();
                    if (files == null) {
                        files = new SmartList();
                    } else if (files.contains(file)) continue;
                    files.add(file);
                }
            }
        }
        finally {
            token.finish();
        }
        List<Object> list = files == null ? Collections.emptyList() : files;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/FileBasedSynchronizer", "getIncorrectFiles"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean scheduleFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/FileBasedSynchronizer", "scheduleFile"));
        }
        Set<PsiElement> set = this.elements;
        synchronized (set) {
            if (this.containsErrors(file)) {
                return false;
            }
        }
        if (PsiTreeUtil.hasErrorElements((PsiElement)file)) {
            set = this.elements;
            synchronized (set) {
                this.incorrectElements.add((PsiElement)file);
            }
            return false;
        }
        set = this.elements;
        synchronized (set) {
            this.elements.add((PsiElement)file);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean schedule(int changeType, @NotNull PsiElement child, @NotNull PsiElement parent, @NotNull PsiFile file) {
        PsiElement affectedElement;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/liveEdit/FileBasedSynchronizer", "schedule"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/liveEdit/FileBasedSynchronizer", "schedule"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/FileBasedSynchronizer", "schedule"));
        }
        PsiElement psiElement = affectedElement = changeType == 3 ? child : parent;
        if (!(affectedElement instanceof PsiFile) && PsiTreeUtil.hasErrorElements((PsiElement)affectedElement)) {
            Set<PsiElement> set = this.elements;
            synchronized (set) {
                this.elements.remove(affectedElement);
                this.incorrectElements.add(affectedElement);
            }
            return false;
        }
        Set<PsiElement> set = this.elements;
        synchronized (set) {
            this.incorrectElements.remove(affectedElement);
            this.elements.add(affectedElement);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Runnable flushSyncTask() {
        PsiElement[] psiElements;
        Set<PsiElement> set = this.elements;
        synchronized (set) {
            if (this.elements.isEmpty()) {
                return null;
            }
            psiElements = this.elements.toArray(new PsiElement[this.elements.size()]);
            this.elements.clear();
        }
        return () -> {
            List<PsiFile> files;
            AccessToken token = ReadAction.start();
            try {
                files = FileBasedSynchronizer.getPsiFiles(psiElements);
            }
            finally {
                token.finish();
            }
            if (files != null) {
                this.sync(files);
            }
        };
    }

    protected abstract void sync(@NotNull List<PsiFile> var1);

    @Nullable
    private static List<PsiFile> getPsiFiles(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/liveEdit/FileBasedSynchronizer", "getPsiFiles"));
        }
        List files = null;
        List blackListedFiles = null;
        for (PsiElement element : elements) {
            if (!element.isValid()) continue;
            PsiFile psiFile = element.getContainingFile();
            if (PsiTreeUtil.hasErrorElements((PsiElement)element)) {
                if (files != null) {
                    files.remove(psiFile);
                }
                if (blackListedFiles == null) {
                    blackListedFiles = new SmartList();
                }
                blackListedFiles.add(psiFile);
                continue;
            }
            if (blackListedFiles != null && blackListedFiles.contains(psiFile)) continue;
            if (files == null) {
                files = new SmartList((Object)psiFile);
                continue;
            }
            if (files.contains(psiFile)) continue;
            files.add(psiFile);
        }
        return files;
    }
}

