/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTokenType;
import com.jetbrains.liveEdit.rangeValue.HtmlValueSynchronizerFactory;
import com.jetbrains.liveEdit.rangeValue.RangeValueSynchronizer;
import com.jetbrains.liveEdit.rangeValue.RangeValueSynchronizerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HtmlLookupSynchronizerFactory
extends RangeValueSynchronizerFactory.Html<RangeValueSynchronizer> {
    HtmlLookupSynchronizerFactory() {
    }

    @Override
    protected RangeValueSynchronizer create(@NotNull PsiFile file, @NotNull XmlAttribute attribute, @Nullable CssDeclaration cssDeclaration) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/HtmlLookupSynchronizerFactory", "create"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/jetbrains/liveEdit/HtmlLookupSynchronizerFactory", "create"));
        }
        if (cssDeclaration == null) {
            PsiElement firstChild = attribute.getFirstChild();
            if (firstChild == attribute.getLastChild() && firstChild.getNode().getElementType() == XmlTokenType.XML_NAME) {
                return null;
            }
            return new AttributeValueLookupSynchronizer(file, attribute);
        }
        return new HtmlValueSynchronizerFactory.InlineStylePropertyValueColorSynchronizer(file, attribute, cssDeclaration);
    }

    private static class AttributeValueLookupSynchronizer
    extends HtmlValueSynchronizerFactory.PropertyValueLookupSynchronizer {
        private AttributeValueLookupSynchronizer(PsiFile file, XmlAttribute attribute) {
            super(file, attribute.getName(), attribute);
        }

        @Override
        @Nullable
        protected CharSequence itemToString(@NotNull LookupElement item, @NotNull String itemLookupString, @NotNull Lookup lookup, boolean closed) {
            int valueEnd;
            int valueStart;
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/liveEdit/HtmlLookupSynchronizerFactory$AttributeValueLookupSynchronizer", "itemToString"));
            }
            if (itemLookupString == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemLookupString", "com/jetbrains/liveEdit/HtmlLookupSynchronizerFactory$AttributeValueLookupSynchronizer", "itemToString"));
            }
            if (lookup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/jetbrains/liveEdit/HtmlLookupSynchronizerFactory$AttributeValueLookupSynchronizer", "itemToString"));
            }
            XmlAttributeValue valueElement = this.attribute.getValueElement();
            if (valueElement == null) {
                return itemLookupString;
            }
            ASTNode attributeValue = null;
            ASTNode attributeValueStart = null;
            for (ASTNode element = valueElement.getNode().getFirstChildNode(); element != null; element = element.getTreeNext()) {
                if (element.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                    attributeValue = element;
                    break;
                }
                if (element.getElementType() != XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) continue;
                attributeValueStart = element;
            }
            if (attributeValue == null) {
                if (attributeValueStart == null) {
                    ASTNode valueElementNode = valueElement.getNode();
                    valueStart = valueElementNode.getStartOffset() + valueElementNode.getTextLength();
                } else {
                    valueStart = attributeValueStart.getStartOffset() + 1;
                }
                valueEnd = valueStart;
            } else {
                valueStart = attributeValue.getStartOffset();
                valueEnd = valueStart + attributeValue.getTextLength();
            }
            return AttributeValueLookupSynchronizer.getEffectiveText(item, itemLookupString, valueStart, valueEnd, lookup, closed);
        }

        @Override
        protected void doSync(@NotNull CharSequence value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/liveEdit/HtmlLookupSynchronizerFactory$AttributeValueLookupSynchronizer", "doSync"));
            }
            this.setProperty(value, false);
        }

        @Override
        protected void doRevert() {
            if (this.attribute.isValid() && !PsiUtilCore.hasErrorElementChild((PsiElement)this.attribute)) {
                this.setProperty(this.attribute.getDisplayValue(), false);
            }
        }
    }
}

