/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.liveEdit.FileBasedSynchronizer;
import com.jetbrains.liveEdit.PageReloader;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class InSingleFileBasedSynchronizer
extends FileBasedSynchronizer {
    @Override
    protected final void sync(@NotNull List<PsiFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/liveEdit/InSingleFileBasedSynchronizer", "sync"));
        }
        MultiMap projectToFiles = MultiMap.createSmart();
        for (PsiFile psiFile : files) {
            projectToFiles.putValue((Object)psiFile.getProject(), (Object)psiFile.getVirtualFile());
        }
        for (Project project : projectToFiles.keySet()) {
            this.scheduleUpdate(projectToFiles.get((Object)project), project);
        }
    }

    protected abstract void scheduleUpdate(@NotNull Collection<VirtualFile> var1, @NotNull Project var2);

    @NotNull
    protected static VirtualFile getVirtualFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/InSingleFileBasedSynchronizer", "getVirtualFile"));
        }
        VirtualFile virtualFile = file.getOriginalFile().getViewProvider().getVirtualFile();
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/InSingleFileBasedSynchronizer", "getVirtualFile"));
        }
        return virtualFile;
    }

    @Override
    public final void reload(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/InSingleFileBasedSynchronizer", "reload"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/InSingleFileBasedSynchronizer", "reload"));
        }
        PageReloader.save(file, project, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/InSingleFileBasedSynchronizer", "lambda$reload$0"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/InSingleFileBasedSynchronizer", "lambda$reload$0"));
            }
            this.doReload(project, file);
        }, true);
    }

    protected abstract void doReload(@NotNull Project var1, @NotNull VirtualFile var2);
}

