/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.css.CssFileType;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.liveEdit.LiveEditManager;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class LiveEditBulkFileListener
extends BulkFileListener.Adapter {
    private final LiveEditManager liveEditManager;

    public LiveEditBulkFileListener(@NotNull LiveEditManager liveEditManager) {
        if (liveEditManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "liveEditManager", "com/jetbrains/liveEdit/LiveEditBulkFileListener", "<init>"));
        }
        this.liveEditManager = liveEditManager;
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/jetbrains/liveEdit/LiveEditBulkFileListener", "after"));
        }
        if (!this.liveEditManager.isOperable()) {
            return;
        }
        List psiFiles = null;
        for (VFileEvent vFileEvent : events) {
            PsiFile psiFile;
            Project project;
            VirtualFile file;
            FileType fileType;
            if (!(vFileEvent instanceof VFileContentChangeEvent) || (fileType = (file = ((VFileContentChangeEvent)vFileEvent).getFile()).getFileType()) != CssFileType.INSTANCE && !JsFileUtil.isScript((FileType)fileType) || (project = ProjectUtil.guessProjectForContentFile((VirtualFile)file, (FileType)fileType)) == null || !this.liveEditManager.isOperable(project) || (psiFile = PsiManager.getInstance((Project)project).findFile(file)) == null || psiFile instanceof PsiPlainText) continue;
            if (psiFiles == null) {
                psiFiles = new SmartList();
            }
            psiFiles.add(psiFile);
        }
        if (ContainerUtil.isEmpty(psiFiles)) {
            return;
        }
        MultiMap projectToPsiFiles = MultiMap.createSmart();
        for (PsiFile psiFile : psiFiles) {
            projectToPsiFiles.putValue((Object)psiFile.getProject(), (Object)psiFile);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            for (Project project : projectToPsiFiles.keySet()) {
                if (project.isDisposed()) continue;
                Collection psiFilesPerProject = projectToPsiFiles.get((Object)project);
                PsiDocumentManager.getInstance((Project)project).performWhenAllCommitted(() -> this.liveEditManager.schedule(psiFilesPerProject));
            }
        });
    }
}

