/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.liveEdit.LiveEditOptions;
import com.jetbrains.liveEdit.UpdatePolicy;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class LiveEditConfigurableUi
implements ConfigurableUi<LiveEditOptions> {
    private JCheckBox elementHighlightingCheckBox;
    private JPanel panel;
    private JCheckBox restartIfHotSwapFailedCheckBox;
    private JRadioButton autoRadioButton;
    private JRadioButton manualRadioButton;
    private JFormattedTextField autoDelayTextField;

    public LiveEditConfigurableUi() {
        this.$$$setupUI$$$();
        UIUtil.configureNumericFormattedTextField((JFormattedTextField)this.autoDelayTextField);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/liveEdit/LiveEditConfigurableUi$1", "actionPerformed"));
                }
                LiveEditConfigurableUi.this.autoDelayTextField.setEnabled(LiveEditConfigurableUi.this.autoRadioButton.isSelected());
            }
        };
        this.autoRadioButton.addActionListener(listener);
        this.manualRadioButton.addActionListener(listener);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/LiveEditConfigurableUi", "getComponent"));
        }
        return jPanel;
    }

    private boolean isElementHighlighting() {
        return this.elementHighlightingCheckBox.isSelected();
    }

    private boolean isRestartIfHotSwapFailed() {
        return this.restartIfHotSwapFailedCheckBox.isSelected();
    }

    @NotNull
    private UpdatePolicy getUpdatePolicy() {
        if (this.autoRadioButton.isSelected()) {
            UpdatePolicy updatePolicy = UpdatePolicy.AUTO;
            if (updatePolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/LiveEditConfigurableUi", "getUpdatePolicy"));
            }
            return updatePolicy;
        }
        UpdatePolicy updatePolicy = UpdatePolicy.MANUAL;
        if (updatePolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/LiveEditConfigurableUi", "getUpdatePolicy"));
        }
        return updatePolicy;
    }

    private int getAutoDelay() {
        Object value = this.autoDelayTextField.getValue();
        return value instanceof Number ? ((Number)value).intValue() : StringUtilRt.parseInt((String)((String)value), (int)300);
    }

    public void reset(@NotNull LiveEditOptions options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/jetbrains/liveEdit/LiveEditConfigurableUi", "reset"));
        }
        this.elementHighlightingCheckBox.setSelected(options.isElementHighlighting());
        this.restartIfHotSwapFailedCheckBox.setSelected(options.isRestartIfHotSwapFailed());
        boolean isAuto = options.getUpdatePolicy() == UpdatePolicy.AUTO;
        this.autoRadioButton.setSelected(isAuto);
        this.autoDelayTextField.setValue(options.getAutoDelay());
        this.autoDelayTextField.setEnabled(isAuto);
        this.manualRadioButton.setSelected(options.getUpdatePolicy() == UpdatePolicy.MANUAL);
    }

    public void apply(@NotNull LiveEditOptions options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/jetbrains/liveEdit/LiveEditConfigurableUi", "apply"));
        }
        if (this.isElementHighlighting() != options.isElementHighlighting()) {
            options.setElementHighlighting(this.isElementHighlighting(), true);
        }
        options.setUpdatePolicy(this.getUpdatePolicy());
        options.setAutoDelay(this.getAutoDelay());
        options.setRestartIfHotSwapFailed(this.isRestartIfHotSwapFailed());
    }

    public boolean isModified(@NotNull LiveEditOptions options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/jetbrains/liveEdit/LiveEditConfigurableUi", "isModified"));
        }
        return this.isElementHighlighting() != options.isElementHighlighting() || this.getUpdatePolicy() != options.getUpdatePolicy() || this.getAutoDelay() != options.getAutoDelay() || this.isRestartIfHotSwapFailed() != options.isRestartIfHotSwapFailed();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JFormattedTextField jFormattedTextField;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.elementHighlightingCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/LiveEditBundle").getString("settings.highlight.on.caret"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/LiveEditBundle").getString("settings.update.title"), (int)0, (int)0, null, null));
        this.autoRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/LiveEditBundle").getString("settings.auto"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.manualRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/LiveEditBundle").getString("settings.manual"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.autoDelayTextField = jFormattedTextField = new JFormattedTextField();
        jFormattedTextField.setColumns(4);
        jPanel2.add((Component)jFormattedTextField, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        this.restartIfHotSwapFailedCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/LiveEditBundle").getString("settings.restart.if.hotswap.fails"));
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/LiveEditBundle").getString("settings.highlight.on.caret.tip"));
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null, 3));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

