/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.javascript.debugger.browserConnection.BrowserConnectionManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.event.PomModelListener;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.TreeChange;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.containers.WeakList;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.jetbrains.liveEdit.ApplicationInspector;
import com.jetbrains.liveEdit.FileBasedSynchronizer;
import com.jetbrains.liveEdit.LiveEditBulkFileListener;
import com.jetbrains.liveEdit.LiveEditOptions;
import com.jetbrains.liveEdit.LiveLookupListener;
import com.jetbrains.liveEdit.PsiSynchronizer;
import com.jetbrains.liveEdit.UpdatePolicy;
import com.jetbrains.liveEdit.highlighting.ElementHighlighter;
import com.jetbrains.liveEdit.rangeValue.RangeValueSynchronizer;
import com.jetbrains.liveEdit.rangeValue.RangeValueSynchronizerFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveEditManager
implements StartupActivity,
DumbAware {
    private static final Key<Disposable> LIVE_LISTENERS_DISPOSABLE_KEY = Key.create((String)"liveEditEventListenerDisposable");
    private static final Key<AtomicInteger> ACTIVE_DEBUG_PROCESS_COUNT = Key.create((String)"liveEditOperable");
    private static final ExtensionPointName<RangeValueSynchronizerFactory<RangeValueSynchronizer>> LOOKUP_SYNCHRONIZER_FACTORY_EP_NAME = ExtensionPointName.create((String)"com.jetbrains.liveEdit.lookupSynchronizerFactory");
    private final Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)ApplicationManager.getApplication());
    private final SyncQueue syncQueue = new SyncQueue(this.alarm);
    private final List<VirtualFile> ignoredFiles = new WeakList();
    private final AtomicBoolean applicationWideListenersAdded = new AtomicBoolean();
    private volatile int applicationWideActiveDebugProcessCount;

    public static LiveEditManager getInstance() {
        return (LiveEditManager)StartupActivity.POST_STARTUP_ACTIVITY.findExtension(LiveEditManager.class);
    }

    @NotNull
    public Alarm getAlarm() {
        Alarm alarm = this.alarm;
        if (alarm == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/LiveEditManager", "getAlarm"));
        }
        return alarm;
    }

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/LiveEditManager", "runActivity"));
        }
        if (project.isDefault()) {
            return;
        }
        project.getMessageBus().connect((Disposable)project).subscribe(XDebuggerManager.TOPIC, (Object)new XDebuggerManagerListener(){

            public void processStarted(@NotNull XDebugProcess debugProcess) {
                if (debugProcess == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/liveEdit/LiveEditManager$1", "processStarted"));
                }
                UpdatePolicy updatePolicy = ApplicationInspector.getInstance().getUpdatePolicy(debugProcess, false);
                if (updatePolicy != UpdatePolicy.DISABLED) {
                    LiveEditManager.this.start(debugProcess.getSession().getProject(), updatePolicy);
                }
            }

            public void processStopped(@NotNull XDebugProcess debugProcess) {
                if (debugProcess == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/liveEdit/LiveEditManager$1", "processStopped"));
                }
                if (LiveEditManager.this.applicationWideActiveDebugProcessCount > 0) {
                    LiveEditManager.this.end(debugProcess.getSession().getProject(), debugProcess);
                }
            }
        });
        if (LiveEditOptions.getInstance().isElementHighlighting()) {
            ElementHighlighter.getInstance().setEnabled(true);
        }
    }

    void start(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/LiveEditManager", "start"));
        }
        this.start(project, LiveEditOptions.getInstance().getUpdatePolicy());
    }

    void end(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/LiveEditManager", "end"));
        }
        this.end(project, null);
    }

    private void start(@NotNull Project project, @NotNull UpdatePolicy updatePolicy) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/LiveEditManager", "start"));
        }
        if (updatePolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatePolicy", "com/jetbrains/liveEdit/LiveEditManager", "start"));
        }
        ++this.applicationWideActiveDebugProcessCount;
        this.startTrackChanges(project, updatePolicy).incrementAndGet();
    }

    private void end(@NotNull Project project, @Nullable XDebugProcess debugProcess) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/LiveEditManager", "end"));
        }
        AtomicInteger activeDebugProcessCount = (AtomicInteger)ACTIVE_DEBUG_PROCESS_COUNT.get((UserDataHolder)project);
        if (activeDebugProcessCount != null && (debugProcess == null || ApplicationInspector.getInstance().getUpdatePolicy(debugProcess, true) != UpdatePolicy.DISABLED)) {
            Disposable disposable;
            --this.applicationWideActiveDebugProcessCount;
            if (activeDebugProcessCount.decrementAndGet() == 0 && (disposable = (Disposable)LIVE_LISTENERS_DISPOSABLE_KEY.get((UserDataHolder)project)) != null) {
                LIVE_LISTENERS_DISPOSABLE_KEY.set((UserDataHolder)project, null);
                Disposer.dispose((Disposable)disposable);
            }
        }
    }

    @NotNull
    private AtomicInteger startTrackChanges(@NotNull Project project, @NotNull UpdatePolicy updatePolicy) {
        AtomicInteger activeDebugProcessCount;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/LiveEditManager", "startTrackChanges"));
        }
        if (updatePolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatePolicy", "com/jetbrains/liveEdit/LiveEditManager", "startTrackChanges"));
        }
        if (this.applicationWideListenersAdded.compareAndSet(false, true)) {
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new LiveEditBulkFileListener(this));
        }
        if ((activeDebugProcessCount = (AtomicInteger)ACTIVE_DEBUG_PROCESS_COUNT.get((UserDataHolder)project)) == null) {
            activeDebugProcessCount = new AtomicInteger();
            ACTIVE_DEBUG_PROCESS_COUNT.set((UserDataHolder)project, (Object)activeDebugProcessCount);
            PomManager.getModel((Project)project).addModelListener((PomModelListener)new MyPomModelListener(project), (Disposable)project);
        }
        if (updatePolicy == UpdatePolicy.AUTO && !LIVE_LISTENERS_DISPOSABLE_KEY.isIn((UserDataHolder)project)) {
            Disposable disposable = Disposer.newDisposable();
            LIVE_LISTENERS_DISPOSABLE_KEY.set((UserDataHolder)project, (Object)disposable);
            Disposer.register((Disposable)project, (Disposable)disposable);
            LookupManager.getInstance((Project)project).addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(@NotNull PropertyChangeEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/liveEdit/LiveEditManager$2", "propertyChange"));
                    }
                    if (!"activeLookup".equals(event.getPropertyName())) {
                        return;
                    }
                    Lookup lookup = (Lookup)event.getNewValue();
                    if (lookup == null) {
                        return;
                    }
                    PsiElement element = lookup.getPsiElement();
                    if (element == null) {
                        return;
                    }
                    PsiFile file = lookup.getPsiFile();
                    if (!file.isPhysical()) {
                        return;
                    }
                    RangeValueSynchronizer synchronizer = (RangeValueSynchronizer)RangeValueSynchronizerFactory.find(element, file, LOOKUP_SYNCHRONIZER_FACTORY_EP_NAME);
                    if (synchronizer != null) {
                        lookup.addLookupListener((LookupListener)new LiveLookupListener(lookup, synchronizer));
                    }
                }
            }, disposable);
        }
        AtomicInteger atomicInteger = activeDebugProcessCount;
        if (atomicInteger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/LiveEditManager", "startTrackChanges"));
        }
        return atomicInteger;
    }

    public boolean isOperable() {
        return this.applicationWideActiveDebugProcessCount > 0 || ApplicationManager.getApplication().isUnitTestMode();
    }

    public boolean isOperable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/LiveEditManager", "isOperable"));
        }
        if (this.applicationWideActiveDebugProcessCount == 0) {
            return false;
        }
        AtomicInteger count = (AtomicInteger)ACTIVE_DEBUG_PROCESS_COUNT.get((UserDataHolder)project);
        return count != null && count.get() > 0;
    }

    public boolean isLiveOperable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/LiveEditManager", "isLiveOperable"));
        }
        return LIVE_LISTENERS_DISPOSABLE_KEY.isIn((UserDataHolder)project);
    }

    public boolean isOperableForBrowser(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/LiveEditManager", "isOperableForBrowser"));
        }
        return this.isOperable(project) && BrowserConnectionManager.getInstance().hasConnections() || ApplicationManager.getApplication().isUnitTestMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignoreFile(@NotNull VirtualFile file, boolean value) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/LiveEditManager", "ignoreFile"));
        }
        List<VirtualFile> list = this.ignoredFiles;
        synchronized (list) {
            if (!value) {
                this.ignoredFiles.remove(file);
            } else if (!this.ignoredFiles.contains(file)) {
                this.ignoredFiles.add(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.syncQueue.lock;
        synchronized (object) {
            if (this.syncQueue.cancel()) {
                this.syncQueue.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(@NotNull Collection<PsiFile> psiFiles) {
        if (psiFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFiles", "com/jetbrains/liveEdit/LiveEditManager", "schedule"));
        }
        Object object = this.syncQueue.lock;
        synchronized (object) {
            boolean canceled = this.syncQueue.cancel();
            boolean scheduled = false;
            for (PsiFile psiFile : psiFiles) {
                if (!psiFile.isValid()) continue;
                FileBasedSynchronizer synchronizer = (FileBasedSynchronizer)PsiSynchronizer.get(psiFile.getFileType());
                assert (synchronizer != null);
                if (!synchronizer.scheduleFile(psiFile)) continue;
                scheduled = true;
            }
            if (scheduled || canceled) {
                this.syncQueue.request();
            }
        }
    }

    private class MyPomModelListener
    implements PomModelListener {
        private final Project project;

        private MyPomModelListener(Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/LiveEditManager$MyPomModelListener", "<init>"));
            }
            this.project = project;
        }

        public void modelChanged(PomModelEvent event) {
            for (PomModelAspect aspect : event.getChangedAspects()) {
                if (!(aspect instanceof TreeAspect)) continue;
                this.update((TreeChangeEvent)event.getChangeSet(aspect));
                return;
            }
        }

        public boolean isAspectChangeInteresting(PomModelAspect aspect) {
            return LiveEditManager.this.isOperable(this.project) && aspect instanceof TreeAspect;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(TreeChangeEvent changeSet) {
            PsiFile file = (PsiFile)changeSet.getRootElement().getPsi();
            if (file == null || !file.isPhysical()) {
                return;
            }
            VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
            if (virtualFile instanceof LightVirtualFile) {
                return;
            }
            List list = LiveEditManager.this.ignoredFiles;
            synchronized (list) {
                if (LiveEditManager.this.ignoredFiles.contains(virtualFile)) {
                    return;
                }
            }
            FileType virtualFileType = virtualFile.getFileType();
            if (ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile, (FileType)virtualFileType)) {
                return;
            }
            FileType fileType = file.getFileType();
            if (fileType != StdFileTypes.JSPX && virtualFileType != fileType) {
                return;
            }
            PsiSynchronizer synchronizer = PsiSynchronizer.get(fileType);
            if (synchronizer == null) {
                return;
            }
            Object object = ((LiveEditManager)LiveEditManager.this).syncQueue.lock;
            synchronized (object) {
                boolean canceled = LiveEditManager.this.syncQueue.cancel();
                boolean scheduled = false;
                for (ASTNode changedElement : changeSet.getChangedElements()) {
                    TreeChange changesByElement = changeSet.getChangesByElement(changedElement);
                    PsiElement psiParent = changedElement.getPsi();
                    if (psiParent == null) continue;
                    for (ASTNode treeElement : changesByElement.getAffectedChildren()) {
                        if (!synchronizer.schedule(changesByElement.getChangeByChild(treeElement).getChangeType(), treeElement.getPsi(), psiParent, file)) continue;
                        scheduled = true;
                    }
                }
                if (scheduled || canceled) {
                    LiveEditManager.this.syncQueue.request();
                }
            }
        }
    }

    private static class SyncQueue
    implements Runnable {
        private final Alarm alarm;
        private boolean alarmRequested;
        final Object lock;
        private final boolean isUnitTestMode;

        public SyncQueue(@NotNull Alarm alarm) {
            if (alarm == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alarm", "com/jetbrains/liveEdit/LiveEditManager$SyncQueue", "<init>"));
            }
            this.lock = new Object();
            this.alarm = alarm;
            this.isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        }

        public void request() {
            this.alarmRequested = true;
            if (this.isUnitTestMode) {
                this.run();
            } else {
                this.alarm.addRequest((Runnable)this, LiveEditOptions.getInstance().getAutoDelay());
            }
        }

        public boolean cancel() {
            if (!this.alarmRequested) {
                return false;
            }
            this.alarm.cancelRequest((Runnable)this);
            this.alarmRequested = false;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List tasks = null;
            Iterator iterator = this.lock;
            synchronized (iterator) {
                this.alarmRequested = false;
                for (PsiSynchronizer synchronizer : (PsiSynchronizer[])PsiSynchronizer.EP_NAME.getExtensions()) {
                    Runnable task = synchronizer.flushSyncTask();
                    if (task == null) continue;
                    if (tasks == null) {
                        tasks = new SmartList();
                    }
                    tasks.add(task);
                }
            }
            if (tasks != null) {
                for (Runnable task : tasks) {
                    task.run();
                }
            }
        }
    }
}

