/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.jetbrains.liveEdit.UpdatePolicy;
import com.jetbrains.liveEdit.highlighting.ElementHighlighter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="LiveEditOptions", storages={@Storage(value="editor.xml")})
public class LiveEditOptions
implements PersistentStateComponent<LiveEditOptions> {
    static final int DEFAULT_AUTO_DELAY = 300;
    private boolean elementHighlighting;
    private boolean restartIfHotSwapFailed;
    private UpdatePolicy updatePolicy = UpdatePolicy.MANUAL;
    private int autoDelay = 300;

    public LiveEditOptions() {
        this.elementHighlighting = !ApplicationManager.getApplication().isUnitTestMode();
    }

    public static LiveEditOptions getInstance() {
        return (LiveEditOptions)ServiceManager.getService(LiveEditOptions.class);
    }

    public void setLiveEditing(boolean value) {
        this.updatePolicy = value ? UpdatePolicy.AUTO : UpdatePolicy.MANUAL;
    }

    public void setElementHighlighting(boolean value) {
        this.setElementHighlighting(value, false);
    }

    public boolean isElementHighlighting() {
        return this.elementHighlighting;
    }

    public void setElementHighlighting(boolean value, boolean userInitiatedAction) {
        if (this.elementHighlighting == value) {
            return;
        }
        this.elementHighlighting = value;
        if (userInitiatedAction) {
            ElementHighlighter.getInstance().setEnabled(value);
        }
    }

    @Attribute
    public boolean isRestartIfHotSwapFailed() {
        return this.restartIfHotSwapFailed;
    }

    public void setRestartIfHotSwapFailed(boolean restartIfHotSwapFailed) {
        this.restartIfHotSwapFailed = restartIfHotSwapFailed;
    }

    @Attribute
    @NotNull
    public UpdatePolicy getUpdatePolicy() {
        UpdatePolicy updatePolicy = this.updatePolicy;
        if (updatePolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/LiveEditOptions", "getUpdatePolicy"));
        }
        return updatePolicy;
    }

    public void setUpdatePolicy(@Nullable UpdatePolicy updatePolicy) {
        this.updatePolicy = updatePolicy == null ? UpdatePolicy.MANUAL : updatePolicy;
    }

    @Attribute
    public int getAutoDelay() {
        return this.autoDelay;
    }

    public void setAutoDelay(int autoDelay) {
        this.autoDelay = autoDelay;
    }

    public LiveEditOptions getState() {
        return this;
    }

    public void loadState(LiveEditOptions state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
        ElementHighlighter.getInstance().setEnabled(this.elementHighlighting);
    }
}

