/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.SingleAlarm;
import com.intellij.xml.util.UserColorLookup;
import com.jetbrains.liveEdit.LiveEditManager;
import com.jetbrains.liveEdit.rangeValue.RangeValueSynchronizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveLookupListener
implements LookupListener,
Runnable {
    private final SingleAlarm alarm;
    private final RangeValueSynchronizer lookupSynchronizer;
    private final Lookup lookup;
    private boolean syncScheduled;

    public LiveLookupListener(@NotNull Lookup lookup, @NotNull RangeValueSynchronizer lookupSynchronizer) {
        if (lookup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/jetbrains/liveEdit/LiveLookupListener", "<init>"));
        }
        if (lookupSynchronizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupSynchronizer", "com/jetbrains/liveEdit/LiveLookupListener", "<init>"));
        }
        this.alarm = new SingleAlarm((Runnable)this, 100);
        this.lookup = lookup;
        this.lookupSynchronizer = lookupSynchronizer;
        LiveEditManager liveEditManager = LiveEditManager.getInstance();
        liveEditManager.ignoreFile(lookup.getPsiFile().getOriginalFile().getViewProvider().getVirtualFile(), true);
        liveEditManager.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookupClosed(@NotNull LookupEvent event, boolean selected) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/liveEdit/LiveLookupListener", "lookupClosed"));
        }
        try {
            this.alarm.cancelRequest((Runnable)this);
            boolean wasScheduled = this.syncScheduled;
            this.syncScheduled = false;
            if (!selected) {
                this.lookupSynchronizer.revert();
            } else if (wasScheduled) {
                this.sync(event.getItem(), true);
            }
        }
        finally {
            LiveEditManager.getInstance().ignoreFile(this.lookup.getPsiFile().getOriginalFile().getViewProvider().getVirtualFile(), false);
        }
    }

    public void itemSelected(LookupEvent event) {
        this.lookupClosed(event, true);
    }

    public void lookupCanceled(LookupEvent event) {
        this.lookupClosed(event, false);
    }

    public void currentItemChanged(LookupEvent event) {
        LookupElement item = event.getItem();
        if (!LiveLookupListener.isApplicableItem(item)) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.lookupSynchronizer.sync(item, this.lookup, false);
            return;
        }
        this.alarm.cancelAndRequest();
        this.syncScheduled = true;
    }

    @Override
    public void run() {
        this.sync(this.lookup.getCurrentItem(), false);
    }

    private void sync(@Nullable LookupElement item, boolean closed) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (LiveLookupListener.isApplicableItem(item)) {
            this.syncScheduled = false;
            this.lookupSynchronizer.sync(item, this.lookup, closed);
        }
    }

    private static boolean isApplicableItem(@Nullable LookupElement item) {
        return item != null && !(item instanceof UserColorLookup);
    }
}

