/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AppUIUtil;
import com.jetbrains.liveEdit.ApplicationInspector;
import com.jetbrains.liveEdit.Deployer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PageReloader {
    @NotNull
    public static Runnable createReloadBelongsToProject(@NotNull PsiElement element, boolean triggeredByExplicitAction) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/liveEdit/PageReloader", "createReloadBelongsToProject"));
        }
        Runnable runnable = PageReloader.createReloadBelongsToProject(element, null, triggeredByExplicitAction);
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/PageReloader", "createReloadBelongsToProject"));
        }
        return runnable;
    }

    @NotNull
    public static Runnable createReloadBelongsToProject(@NotNull PsiElement element, @Nullable String selector, boolean triggeredByExplicitAction) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/liveEdit/PageReloader", "createReloadBelongsToProject"));
        }
        Project project = element.getProject();
        Runnable runnable = PageReloader.createSaveTask(element.getContainingFile().getViewProvider().getVirtualFile(), project, PageReloader.domTask(project, selector), triggeredByExplicitAction);
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/PageReloader", "createReloadBelongsToProject"));
        }
        return runnable;
    }

    public static void save(List<PsiFile> files, Condition<List<PsiFile>> actualizer, Runnable callback) {
        PageReloader.saveFiles(files, callback, false, actualizer);
    }

    private static Runnable domTask(@NotNull Project project, @Nullable String selector) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/PageReloader", "domTask"));
        }
        return () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/PageReloader", "lambda$domTask$0"));
            }
            ApplicationInspector applicationInspector = ApplicationInspector.getInstance();
            if (selector == null) {
                applicationInspector.reloadPages(project);
            } else {
                applicationInspector.reloadPagesContainingElement(project, selector);
            }
        };
    }

    public static void reloadBelongsTo(@NotNull VirtualFile file, @NotNull Project project, boolean triggeredByExplicitAction) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/PageReloader", "reloadBelongsTo"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/PageReloader", "reloadBelongsTo"));
        }
        PageReloader.save(file, project, PageReloader.domTask(project, null), triggeredByExplicitAction);
    }

    public static void save(@NotNull VirtualFile file, @NotNull Project project, @NotNull Runnable callback, boolean triggeredByExplicitAction) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/PageReloader", "save"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/PageReloader", "save"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/jetbrains/liveEdit/PageReloader", "save"));
        }
        AppUIUtil.invokeOnEdt((Runnable)PageReloader.createSaveTask(file, project, callback, triggeredByExplicitAction));
    }

    @NotNull
    private static Runnable createSaveTask(@NotNull VirtualFile file, @NotNull Project project, @NotNull Runnable callback, boolean triggeredByExplicitAction) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/PageReloader", "createSaveTask"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/PageReloader", "createSaveTask"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/jetbrains/liveEdit/PageReloader", "createSaveTask"));
        }
        Runnable runnable = () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/PageReloader", "lambda$createSaveTask$1"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/jetbrains/liveEdit/PageReloader", "lambda$createSaveTask$1"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/PageReloader", "lambda$createSaveTask$1"));
            }
            if (project.isDisposed()) {
                return;
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            Deployer deployer = Deployer.getInstance();
            if (deployer == null) {
                callback.run();
            } else {
                deployer.deploy(file, project, triggeredByExplicitAction).doWhenDone(callback);
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/PageReloader", "createSaveTask"));
        }
        return runnable;
    }

    private static void saveFiles(List<PsiFile> files, Runnable callback, boolean triggeredByExplicitAction, Condition<List<PsiFile>> actualizer) {
        AppUIUtil.invokeOnEdt(() -> {
            if (!actualizer.value((Object)files)) {
                return;
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            Deployer deployer = Deployer.getInstance();
            if (deployer == null) {
                callback.run();
                return;
            }
            ActionCallback actionCallback = new ActionCallback(files.size());
            actionCallback.doWhenDone(callback);
            Runnable onUpdateFinished = actionCallback.createSetDoneRunnable();
            for (PsiFile file : files) {
                if (!file.isValid() || file.getProject().isDisposed()) {
                    actionCallback.setDone();
                    continue;
                }
                deployer.deploy(file, triggeredByExplicitAction).doWhenDone(onUpdateFinished);
            }
        });
    }
}

