/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.liveEdit.PageReloader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiSynchronizer {
    public static final ExtensionPointName<PsiSynchronizer> EP_NAME = ExtensionPointName.create((String)"com.jetbrains.liveEdit.synchronizer");

    public abstract boolean canHandle(@NotNull FileType var1);

    public abstract boolean schedule(int var1, @NotNull PsiElement var2, @NotNull PsiElement var3, @NotNull PsiFile var4);

    @Nullable
    public abstract Runnable flushSyncTask();

    public void reload(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/PsiSynchronizer", "reload"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/PsiSynchronizer", "reload"));
        }
        PageReloader.reloadBelongsTo(file, project, true);
    }

    @Nullable
    public static PsiSynchronizer get(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/jetbrains/liveEdit/PsiSynchronizer", "get"));
        }
        for (PsiSynchronizer synchronizer : (PsiSynchronizer[])EP_NAME.getExtensions()) {
            if (!synchronizer.canHandle(fileType)) continue;
            return synchronizer;
        }
        return null;
    }
}

