/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.actions;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.liveEdit.ApplicationInspector;
import com.jetbrains.liveEdit.update.UpdateConfigurationProvider;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u00020\u000e2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J\u0017\u0010\u0014\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R:\u0010\u0003\u001a.\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\b\u00a2\u0006\u0002\b\u00070\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\t\u001a0\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000b0\u000b \u0006*\u0017\u0012\u000e\b\u0001\u0012\n \u0006*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\u0002\b\u00070\n\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/liveEdit/actions/UpdateRunningApplicationAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "blackListedDebugProcesses", "", "Lcom/intellij/xdebugger/XDebugProcess;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "updateConfigurationProviders", "", "Lcom/jetbrains/liveEdit/update/UpdateConfigurationProvider;", "[Lcom/jetbrains/liveEdit/update/UpdateConfigurationProvider;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "doUpdate", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "getDebugProcess", "project", "Lcom/intellij/openapi/project/Project;", "update", "LiveEdit"})
public final class UpdateRunningApplicationAction
extends AnAction {
    private final Set<XDebugProcess> blackListedDebugProcesses = ContainerUtil.newConcurrentSet();
    private final UpdateConfigurationProvider[] updateConfigurationProviders = (UpdateConfigurationProvider[])UpdateConfigurationProvider.EP_NAME.getExtensions();

    private final XDebugProcess getDebugProcess(Project project) {
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        return xDebugSession != null ? xDebugSession.getDebugProcess() : null;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        Presentation presentation = e.getPresentation();
        RunProfile runProfile = (RunProfile)e.getData(LangDataKeys.RUN_PROFILE);
        if (runProfile == null) {
            presentation.setText("Update Application" + (PlatformUtils.isWebStorm() ? "" : " (Live Edit)"));
            presentation.setEnabledAndVisible(!XDebuggerManager.getInstance((Project)project2).getDebugProcesses(JavaScriptDebugProcess.class).isEmpty());
        } else {
            UpdateConfigurationProvider[] updateConfigurationProviderArray = this.updateConfigurationProviders;
            for (int i = 0; i < updateConfigurationProviderArray.length; ++i) {
                UpdateConfigurationProvider provider = updateConfigurationProviderArray[i];
                if (!provider.isSupported(runProfile)) continue;
                presentation.setText("Update '" + runProfile.getName() + "'");
                presentation.setVisible(true);
                Project project3 = project2;
                Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
                presentation.setEnabled(this.getDebugProcess(project3) != null);
                return;
            }
            presentation.setEnabledAndVisible(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        RunProfile runProfile = (RunProfile)e.getData(LangDataKeys.RUN_PROFILE);
        if (runProfile == null) {
            Iterator iterator = XDebuggerManager.getInstance((Project)project2).getDebugProcesses(JavaScriptDebugProcess.class).iterator();
            while (iterator.hasNext()) {
                JavaScriptDebugProcess debugProcess;
                JavaScriptDebugProcess javaScriptDebugProcess = debugProcess = (JavaScriptDebugProcess)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)javaScriptDebugProcess, (String)"debugProcess");
                this.doUpdate(javaScriptDebugProcess);
            }
        } else {
            Project project3 = project2;
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
            XDebugProcess debugProcess = this.getDebugProcess(project3);
            if (debugProcess instanceof JavaScriptDebugProcess) {
                this.doUpdate((JavaScriptDebugProcess)debugProcess);
            }
        }
    }

    private final void doUpdate(JavaScriptDebugProcess<?> debugProcess) {
        if (this.blackListedDebugProcesses.contains(debugProcess)) {
            return;
        }
        Promise<?> callback = ApplicationInspector.getInstance().updateApplication(debugProcess);
        if (Intrinsics.areEqual((Object)callback.getState(), (Object)Promise.State.PENDING)) {
            this.blackListedDebugProcesses.add((XDebugProcess)debugProcess);
            Promise<?> $receiver$iv = callback;
            Intrinsics.checkExpressionValueIsNotNull((Object)$receiver$iv.processed((Consumer)new Consumer<Object>(this, debugProcess){
                final /* synthetic */ UpdateRunningApplicationAction this$0;
                final /* synthetic */ JavaScriptDebugProcess $debugProcess$inlined;
                {
                    this.this$0 = updateRunningApplicationAction;
                    this.$debugProcess$inlined = javaScriptDebugProcess;
                }

                public final void consume(Object it) {
                    UpdateRunningApplicationAction.access$getBlackListedDebugProcesses$p(this.this$0).remove(this.$debugProcess$inlined);
                }
            }), (String)"(this as Promise<Any?>).processed({ handler() })");
        }
    }

    public UpdateRunningApplicationAction() {
        super("Update application", null, AllIcons.Javaee.UpdateRunningApplication);
    }

    @NotNull
    public static final /* synthetic */ Set access$getBlackListedDebugProcesses$p(UpdateRunningApplicationAction $this) {
        return $this.blackListedDebugProcesses;
    }
}

