/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.elementsInspector;

import com.google.common.base.CharMatcher;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.impl.StructureViewSelectInTarget;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.RunnerContentProvider;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Url;
import com.intellij.util.io.socketConnection.ConnectionState;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.xml.util.HtmlUtil;
import com.jetbrains.liveEdit.elementsInspector.ElementsView;
import com.jetbrains.liveEdit.elementsInspector.ElementsViewKt;
import com.jetbrains.liveEdit.elementsInspector.InspectorElementHighlightExecutor;
import com.jetbrains.liveEdit.elementsInspector.InspectorFileReferenceHelper;
import com.jetbrains.liveEdit.elementsInspector.InspectorStructureViewWrapper;
import com.jetbrains.liveEdit.elementsInspector.UpdateQueue;
import com.jetbrains.liveEdit.highlighting.ElementHighlighter;
import com.jetbrains.liveEdit.highlighting.ElementHighlighterOnCaretChangeBase;
import com.jetbrains.liveEdit.highlighting.LiveEditElementPreviewProvider;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.jsonProtocol.EventMap;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.NodeIdentifiable;
import org.jetbrains.wip.protocol.ProtocolResponseReader;
import org.jetbrains.wip.protocol.dom.AttributeModifiedEventData;
import org.jetbrains.wip.protocol.dom.AttributeRemovedEventData;
import org.jetbrains.wip.protocol.dom.CharacterDataModifiedEventData;
import org.jetbrains.wip.protocol.dom.ChildNodeCountUpdatedEventData;
import org.jetbrains.wip.protocol.dom.ChildNodeInsertedEventData;
import org.jetbrains.wip.protocol.dom.ChildNodeRemovedEventData;
import org.jetbrains.wip.protocol.dom.DOMKt;
import org.jetbrains.wip.protocol.dom.DocumentUpdatedEventData;
import org.jetbrains.wip.protocol.dom.GetDocumentResult;
import org.jetbrains.wip.protocol.dom.InlineStyleInvalidatedEventData;
import org.jetbrains.wip.protocol.dom.NodeValue;
import org.jetbrains.wip.protocol.dom.SetChildNodesEventData;
import org.jetbrains.wip.protocol.page.DomContentEventFiredEventData;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u000e\b\u0000\u0018\u00002\u00020\u0001:\u0002\\]B'\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0016\u00106\u001a\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u00020:09H\u0002J\u0010\u0010;\u001a\u0002072\u0006\u0010<\u001a\u00020=H\u0002J9\u0010>\u001a\u0002072\f\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@2\u0006\u0010B\u001a\u00020C2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E0!2\u0006\u0010F\u001a\u00020GH\u0000\u00a2\u0006\u0002\bHJ.\u0010I\u001a\u0002072\u0006\u0010B\u001a\u00020C2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E0!2\u0006\u0010J\u001a\u00020A2\u0006\u0010K\u001a\u00020LH\u0002J\b\u0010M\u001a\u000207H\u0002J\u001e\u0010N\u001a\u0002072\u0006\u0010O\u001a\u00020P2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E0!H\u0002J#\u0010Q\u001a\u0002072\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E0!2\u0006\u0010R\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\bSJ\b\u0010T\u001a\u000207H\u0016J\b\u0010U\u001a\u000207H\u0002J\b\u0010V\u001a\u000207H\u0002J\u0015\u0010W\u001a\u0002072\u0006\u0010X\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\bYJ\u0010\u0010Z\u001a\u0002072\u0006\u0010[\u001a\u00020GH\u0002R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R \u0010(\u001a\u0004\u0018\u00010)8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R \u0010.\u001a\u0004\u0018\u00010/8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lcom/jetbrains/liveEdit/elementsInspector/ElementsView;", "Lcom/intellij/openapi/Disposable;", "connection", "Lorg/jetbrains/debugger/connection/VmConnection;", "Lorg/jetbrains/debugger/Vm;", "project", "Lcom/intellij/openapi/project/Project;", "finder", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "(Lorg/jetbrains/debugger/connection/VmConnection;Lcom/intellij/openapi/project/Project;Lcom/intellij/javascript/debugger/DebuggableFileFinder;)V", "commandProcessor", "Lorg/jetbrains/wip/WipCommandProcessor;", "getCommandProcessor$LiveEdit", "()Lorg/jetbrains/wip/WipCommandProcessor;", "setCommandProcessor$LiveEdit", "(Lorg/jetbrains/wip/WipCommandProcessor;)V", "document", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "getDocument$LiveEdit", "()Lcom/intellij/openapi/editor/ex/DocumentEx;", "documentId", "", "getDocumentId$LiveEdit", "()I", "setDocumentId$LiveEdit", "(I)V", "editorWrapper", "Ljavax/swing/JPanel;", "firstDomContentEventFired", "Ljava/util/concurrent/atomic/AtomicBoolean;", "inspectorStructureViewWrapper", "Lcom/jetbrains/liveEdit/elementsInspector/InspectorStructureViewWrapper;", "nodeIdToRangeMarker", "Lgnu/trove/TIntObjectHashMap;", "Lcom/intellij/openapi/editor/RangeMarker;", "getNodeIdToRangeMarker$LiveEdit", "()Lgnu/trove/TIntObjectHashMap;", "panelShown", "getProject$LiveEdit", "()Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/xml/XmlFile;", "getPsiFile$LiveEdit", "()Lcom/intellij/psi/xml/XmlFile;", "setPsiFile$LiveEdit", "(Lcom/intellij/psi/xml/XmlFile;)V", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "getTextEditor$LiveEdit", "()Lcom/intellij/openapi/fileEditor/TextEditor;", "setTextEditor$LiveEdit", "(Lcom/intellij/openapi/fileEditor/TextEditor;)V", "updateQueue", "Lcom/jetbrains/liveEdit/elementsInspector/UpdateQueue;", "addDomChangeListeners", "", "map", "Lorg/jetbrains/jsonProtocol/EventMap;", "Lorg/jetbrains/wip/protocol/ProtocolResponseReader;", "addElementHighlighter", "highlightExecutor", "Lcom/jetbrains/liveEdit/elementsInspector/InspectorElementHighlightExecutor;", "buildStringRepresentation", "nodes", "", "Lorg/jetbrains/wip/protocol/dom/NodeValue;", "builder", "Ljava/lang/StringBuilder;", "nodeIdToOffset", "Lcom/intellij/openapi/util/Segment;", "newLineBeforeTag", "", "buildStringRepresentation$LiveEdit", "buildTag", "node", "nodeName", "", "clearQueueAndState", "createEditor", "charSequence", "", "createPointers", "insertionOffset", "createPointers$LiveEdit", "dispose", "initAndLoadDocument", "loadDocument", "requestChildNodes", "id", "requestChildNodes$LiveEdit", "setReadOnly", "value", "ActualDomElementHighlighterOnCaretChange", "ElementsRunnerContentProvider", "LiveEdit"})
public final class ElementsView
implements Disposable {
    @Nullable
    private WipCommandProcessor commandProcessor;
    private final JPanel editorWrapper;
    @Nullable
    private volatile TextEditor textEditor;
    @Nullable
    private volatile XmlFile psiFile;
    @NotNull
    private final TIntObjectHashMap<RangeMarker> nodeIdToRangeMarker;
    private int documentId;
    private final UpdateQueue updateQueue;
    private final AtomicBoolean firstDomContentEventFired;
    private final AtomicBoolean panelShown;
    private final InspectorStructureViewWrapper inspectorStructureViewWrapper;
    private VmConnection<Vm> connection;
    @NotNull
    private final Project project;
    private DebuggableFileFinder finder;

    @Nullable
    public final WipCommandProcessor getCommandProcessor$LiveEdit() {
        return this.commandProcessor;
    }

    public final void setCommandProcessor$LiveEdit(@Nullable WipCommandProcessor wipCommandProcessor) {
        this.commandProcessor = wipCommandProcessor;
    }

    @Nullable
    public final TextEditor getTextEditor$LiveEdit() {
        return this.textEditor;
    }

    public final void setTextEditor$LiveEdit(@Nullable TextEditor textEditor) {
        this.textEditor = textEditor;
    }

    @Nullable
    public final XmlFile getPsiFile$LiveEdit() {
        return this.psiFile;
    }

    public final void setPsiFile$LiveEdit(@Nullable XmlFile xmlFile) {
        this.psiFile = xmlFile;
    }

    @NotNull
    public final TIntObjectHashMap<RangeMarker> getNodeIdToRangeMarker$LiveEdit() {
        return this.nodeIdToRangeMarker;
    }

    public final int getDocumentId$LiveEdit() {
        return this.documentId;
    }

    public final void setDocumentId$LiveEdit(int n) {
        this.documentId = n;
    }

    @NotNull
    public final DocumentEx getDocument$LiveEdit() {
        TextEditor textEditor = this.textEditor;
        if (textEditor == null) {
            Intrinsics.throwNpe();
        }
        Document document = textEditor.getEditor().getDocument();
        if (document == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.DocumentEx");
        }
        return (DocumentEx)document;
    }

    private final void initAndLoadDocument() {
        WipCommandProcessor wipCommandProcessor = this.commandProcessor;
        if (wipCommandProcessor == null) {
            Intrinsics.throwNpe();
        }
        this.addDomChangeListeners((EventMap<ProtocolResponseReader>)wipCommandProcessor.getEventMap());
        this.loadDocument();
    }

    private final void addDomChangeListeners(EventMap<ProtocolResponseReader> map) {
        map.add((EventType)DocumentUpdatedEventData.TYPE, (Function1)new Function1<DocumentUpdatedEventData, Unit>(this){
            final /* synthetic */ ElementsView this$0;

            public final void invoke(@Nullable DocumentUpdatedEventData it) {
                ElementsView.access$clearQueueAndState(this.this$0);
                ElementsView.access$loadDocument(this.this$0);
            }
            {
                this.this$0 = elementsView;
                super(1);
            }
        });
        map.addMulti(new EventType[]{(EventType)AttributeModifiedEventData.TYPE, (EventType)AttributeRemovedEventData.TYPE, (EventType)CharacterDataModifiedEventData.TYPE, (EventType)ChildNodeRemovedEventData.TYPE, (EventType)ChildNodeCountUpdatedEventData.TYPE}, (Function1)new Function1<NodeIdentifiable, Unit>(this){
            final /* synthetic */ ElementsView this$0;

            public final void invoke(@NotNull NodeIdentifiable it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ElementsView.access$getUpdateQueue$p(this.this$0).add(it);
            }
            {
                this.this$0 = elementsView;
                super(1);
            }
        });
        map.add((EventType)ChildNodeInsertedEventData.TYPE, (Function1)new Function1<ChildNodeInsertedEventData, Unit>(this){
            final /* synthetic */ ElementsView this$0;

            public final void invoke(@NotNull ChildNodeInsertedEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ElementsView.access$getUpdateQueue$p(this.this$0).childNodeInserted(it);
            }
            {
                this.this$0 = elementsView;
                super(1);
            }
        });
        map.add((EventType)InlineStyleInvalidatedEventData.TYPE, (Function1)new Function1<InlineStyleInvalidatedEventData, Unit>(this){
            final /* synthetic */ ElementsView this$0;

            public final void invoke(@NotNull InlineStyleInvalidatedEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ElementsView.access$getUpdateQueue$p(this.this$0).inlineStyleInvalidated(it.nodeIds());
            }
            {
                this.this$0 = elementsView;
                super(1);
            }
        });
        map.add((EventType)SetChildNodesEventData.TYPE, (Function1)new Function1<SetChildNodesEventData, Unit>(this){
            final /* synthetic */ ElementsView this$0;

            public final void invoke(@NotNull SetChildNodesEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ElementsView.access$getUpdateQueue$p(this.this$0).childNodesSet(it);
            }
            {
                this.this$0 = elementsView;
                super(1);
            }
        });
    }

    private final void loadDocument() {
        WipCommandProcessor wipCommandProcessor = this.commandProcessor;
        if (wipCommandProcessor == null) {
            Intrinsics.throwNpe();
        }
        wipCommandProcessor.send((Request)DOMKt.GetDocument()).done((Consumer)new Consumer<GetDocumentResult>(this){
            final /* synthetic */ ElementsView this$0;

            public final void consume(GetDocumentResult result) {
                CharSequence charSequence = result.root().getDocumentURL();
                if (charSequence == null || charSequence.length() == 0) {
                    return;
                }
                AppUIUtil.invokeLaterIfProjectAlive((Project)this.this$0.getProject$LiveEdit(), (Runnable)new Runnable(this, result){
                    final /* synthetic */ loadDocument.1 this$0;
                    final /* synthetic */ GetDocumentResult $result;

                    public final void run() {
                        StringBuilder builder = new StringBuilder();
                        TIntObjectHashMap nodeIdToOffset = new TIntObjectHashMap();
                        this.this$0.this$0.setDocumentId$LiveEdit(this.$result.root().getNodeId());
                        ElementsView elementsView = this.this$0.this$0;
                        List list = this.$result.root().getChildren();
                        if (list == null) {
                            Intrinsics.throwNpe();
                        }
                        elementsView.buildStringRepresentation$LiveEdit(list, builder, (TIntObjectHashMap<Segment>)nodeIdToOffset, false);
                        if (this.this$0.this$0.getTextEditor$LiveEdit() == null) {
                            ElementsView.access$createEditor(this.this$0.this$0, builder, nodeIdToOffset);
                        } else {
                            DocumentUtil.writeInRunUndoTransparentAction((Runnable)new Runnable(this, builder, nodeIdToOffset){
                                final /* synthetic */ loadDocument.1 this$0;
                                final /* synthetic */ StringBuilder $builder;
                                final /* synthetic */ TIntObjectHashMap $nodeIdToOffset;

                                public final void run() {
                                    DocumentEx document = this.this$0.this$0.this$0.getDocument$LiveEdit();
                                    document.setText((CharSequence)this.$builder);
                                    this.this$0.this$0.this$0.createPointers$LiveEdit((TIntObjectHashMap<Segment>)this.$nodeIdToOffset, 0);
                                    PsiDocumentManager.getInstance((Project)this.this$0.this$0.this$0.getProject$LiveEdit()).commitDocument((Document)document);
                                    CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.this$0.this$0.this$0.getProject$LiveEdit());
                                    XmlFile xmlFile = this.this$0.this$0.this$0.getPsiFile$LiveEdit();
                                    if (xmlFile == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    codeStyleManager.reformat((PsiElement)xmlFile, true);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$builder = stringBuilder;
                                    this.$nodeIdToOffset = tIntObjectHashMap;
                                }
                            });
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$result = getDocumentResult;
                    }
                });
            }
            {
                this.this$0 = elementsView;
            }
        });
    }

    public final void buildStringRepresentation$LiveEdit(@NotNull List<? extends NodeValue> nodes, @NotNull StringBuilder builder, @NotNull TIntObjectHashMap<Segment> nodeIdToOffset, boolean newLineBeforeTag) {
        Intrinsics.checkParameterIsNotNull(nodes, (String)"nodes");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull(nodeIdToOffset, (String)"nodeIdToOffset");
        boolean newLineBeforeTag2 = newLineBeforeTag;
        block8: for (NodeValue nodeValue : nodes) {
            String nodeName = nodeValue.nodeName();
            if (!StringUtil.isEmpty((String)nodeName)) {
                Locale locale;
                String string = nodeName;
                Intrinsics.checkExpressionValueIsNotNull((Object)Locale.ENGLISH, (String)"Locale.ENGLISH");
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
                nodeName = string3;
            }
            switch ((short)nodeValue.getNodeType()) {
                case 1: {
                    if (newLineBeforeTag2) {
                        if (!HtmlUtil.isPossiblyInlineTag((String)nodeName)) {
                            builder.append('\n');
                        }
                    } else {
                        newLineBeforeTag2 = true;
                    }
                    this.buildTag(builder, nodeIdToOffset, nodeValue, nodeName);
                    continue block8;
                }
                case 3: {
                    int start = builder.length();
                    ElementsViewKt.convertLineSeparators(nodeValue.nodeValue(), builder);
                    nodeIdToOffset.put(nodeValue.getNodeId(), (Object)new TextRange(start, builder.length()));
                    continue block8;
                }
                case 2: {
                    builder.append(' ');
                    builder.append(nodeValue.getName());
                    ElementsViewKt.appendAttributeValue(nodeValue.getValue(), builder);
                    continue block8;
                }
                case 8: {
                    if (newLineBeforeTag2) {
                        builder.append('\n');
                    } else {
                        newLineBeforeTag2 = true;
                    }
                    builder.append("<!--");
                    ElementsViewKt.convertLineSeparators(nodeValue.nodeValue(), builder);
                    builder.append("-->");
                    continue block8;
                }
                case 10: {
                    builder.append("<!DOCTYPE ").append(nodeName);
                    if (!StringUtil.isEmpty((String)nodeValue.getPublicId())) {
                        builder.append(" PUBLIC \"").append(nodeValue.getPublicId()).append('\"');
                        if (nodeValue.getSystemId() != null) {
                            builder.append(' ').append('\"').append(nodeValue.getSystemId()).append('\"');
                        }
                    } else if (!StringUtil.isEmpty((String)nodeValue.getSystemId())) {
                        builder.append(" SYSTEM \"").append(nodeValue.getPublicId()).append('\"');
                    }
                    if (!StringUtil.isEmpty((String)nodeValue.getInternalSubset())) {
                        builder.append(' ').append('[').append(nodeValue.getInternalSubset()).append(']');
                    }
                    builder.append('>');
                    continue block8;
                }
                case 4: {
                    builder.append("<![CDATA[");
                    ElementsViewKt.convertLineSeparators(nodeValue.nodeValue(), builder);
                    builder.append("]]>");
                    continue block8;
                }
            }
            builder.append(CharMatcher.WHITESPACE.collapseFrom((CharSequence)nodeName, ' '));
        }
    }

    private final void buildTag(StringBuilder builder, TIntObjectHashMap<Segment> nodeIdToOffset, NodeValue node, String nodeName) {
        boolean hasAttributes;
        builder.append('<').append(nodeName);
        List attributes = node.getAttributes();
        boolean bl = hasAttributes = attributes != null && !attributes.isEmpty();
        if (hasAttributes) {
            int i = 0;
            while (true) {
                List list = attributes;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                if (i >= list.size()) break;
                String name = (String)attributes.get(i);
                String value = StringUtil.nullize((String)((String)attributes.get(i + 1)));
                if (value == null && Intrinsics.areEqual((Object)"style", (Object)name)) {
                    i += 2;
                    continue;
                }
                builder.append(' ');
                builder.append(name);
                ElementsViewKt.appendAttributeValue(value, builder);
                i += 2;
            }
        }
        int start = builder.length();
        if (HtmlUtil.isSingleHtmlTag((String)nodeName)) {
            builder.append('/').append('>');
            nodeIdToOffset.put(node.getNodeId(), (Object)new TextRange(start, builder.length()));
            return;
        }
        builder.append('>');
        if (node.getChildren() == null) {
            this.requestChildNodes$LiveEdit(node.getNodeId());
        } else {
            List list = node.getChildren();
            if (list == null) {
                Intrinsics.throwNpe();
            }
            if (!list.isEmpty()) {
                List list2 = node.getChildren();
                if (list2 == null) {
                    Intrinsics.throwNpe();
                }
                this.buildStringRepresentation$LiveEdit(list2, builder, nodeIdToOffset, true);
            }
        }
        builder.append('<').append('/').append(nodeName).append('>');
        nodeIdToOffset.put(node.getNodeId(), (Object)new TextRange(start, builder.length()));
    }

    public final void requestChildNodes$LiveEdit(int id) {
        WipCommandProcessor wipCommandProcessor = this.commandProcessor;
        if (wipCommandProcessor == null) {
            Intrinsics.throwNpe();
        }
        wipCommandProcessor.send((Request)DOMKt.RequestChildNodes((int)id, (int)-1));
    }

    public final void createPointers$LiveEdit(@NotNull TIntObjectHashMap<Segment> nodeIdToOffset, int insertionOffset) {
        Intrinsics.checkParameterIsNotNull(nodeIdToOffset, (String)"nodeIdToOffset");
        DocumentEx document = this.getDocument$LiveEdit();
        nodeIdToOffset.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Segment>(this, document, insertionOffset){
            final /* synthetic */ ElementsView this$0;
            final /* synthetic */ DocumentEx $document;
            final /* synthetic */ int $insertionOffset;

            public final boolean execute(int nodeId, Segment range) {
                this.this$0.getNodeIdToRangeMarker$LiveEdit().put(nodeId, (Object)this.$document.createRangeMarker(this.$insertionOffset + range.getStartOffset(), this.$insertionOffset + range.getEndOffset()));
                return true;
            }
            {
                this.this$0 = elementsView;
                this.$document = documentEx;
                this.$insertionOffset = n;
            }
        });
    }

    private final void createEditor(CharSequence charSequence, TIntObjectHashMap<Segment> nodeIdToOffset) {
        VirtualFile realFile;
        VirtualFile virtualFile;
        Vm vm;
        Url currentUrl;
        PsiFile psiFile = PsiFileFactory.getInstance((Project)this.project).createFileFromText("", (Language)HTMLLanguage.INSTANCE, charSequence, true, false);
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
        }
        XmlFile xmlFile = this.psiFile = (XmlFile)psiFile;
        if (xmlFile == null) {
            Intrinsics.throwNpe();
        }
        VirtualFile virtualFile2 = xmlFile.getViewProvider().getVirtualFile();
        FileEditor fileEditor = TextEditorProvider.getInstance().createEditor(this.project, virtualFile2);
        if (fileEditor == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
        }
        this.textEditor = (TextEditor)fileEditor;
        this.createPointers$LiveEdit(nodeIdToOffset, 0);
        VmConnection<Vm> vmConnection = this.connection;
        if (vmConnection == null) {
            Intrinsics.throwNpe();
        }
        Url url = currentUrl = (vm = vmConnection.getVm()) == null ? null : ((WipVm)vm).getCurrentUrl();
        if (currentUrl == null) {
            virtualFile = null;
        } else {
            DebuggableFileFinder debuggableFileFinder = this.finder;
            if (debuggableFileFinder == null) {
                Intrinsics.throwNpe();
            }
            virtualFile = realFile = debuggableFileFinder.findFile(currentUrl, this.project);
        }
        if (realFile != null) {
            PsiFile originalFile;
            if (this.psiFile instanceof PsiFileImpl && (originalFile = PsiManager.getInstance((Project)this.project).findFile(realFile)) != null) {
                XmlFile xmlFile2 = this.psiFile;
                if (xmlFile2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
                }
                ((PsiFileImpl)xmlFile2).setOriginalFile(originalFile);
            }
            InspectorFileReferenceHelper.registerFile(virtualFile2, realFile);
        }
        DocumentUtil.writeInRunUndoTransparentAction((Runnable)new Runnable(this){
            final /* synthetic */ ElementsView this$0;

            public final void run() {
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.this$0.getProject$LiveEdit());
                XmlFile xmlFile = this.this$0.getPsiFile$LiveEdit();
                if (xmlFile == null) {
                    Intrinsics.throwNpe();
                }
                codeStyleManager.reformat((PsiElement)xmlFile, true);
            }
            {
                this.this$0 = elementsView;
            }
        });
        this.setReadOnly(true);
        XmlFile xmlFile3 = this.psiFile;
        if (xmlFile3 == null) {
            Intrinsics.throwNpe();
        }
        StructureViewSelectInTarget.CUSTOM_STRUCTURE_VIEW_KEY.set((UserDataHolder)xmlFile3.getViewProvider().getVirtualFile(), (Object)this.inspectorStructureViewWrapper);
        this.inspectorStructureViewWrapper.setTextEditor(this.textEditor);
        InspectorElementHighlightExecutor highlightExecutor = new InspectorElementHighlightExecutor(this);
        LiveEditElementPreviewProvider.CUSTOM_HIGHLIGHT_EXECUTOR_KEY.set((UserDataHolder)this.psiFile, (Object)highlightExecutor);
        this.addElementHighlighter(highlightExecutor);
        TextEditor textEditor = this.textEditor;
        if (textEditor == null) {
            Intrinsics.throwNpe();
        }
        this.editorWrapper.add((Component)textEditor.getComponent(), "Center");
        SwingUtilities.invokeLater(new Runnable(this){
            final /* synthetic */ ElementsView this$0;

            public final void run() {
                ElementsView.access$getEditorWrapper$p(this.this$0).revalidate();
                ElementsView.access$getEditorWrapper$p(this.this$0).repaint();
            }
            {
                this.this$0 = elementsView;
            }
        });
    }

    private final void addElementHighlighter(InspectorElementHighlightExecutor highlightExecutor) {
        ActualDomElementHighlighterOnCaretChange listener = new ActualDomElementHighlighterOnCaretChange(highlightExecutor);
        TextEditor textEditor = this.textEditor;
        if (textEditor == null) {
            Intrinsics.throwNpe();
        }
        textEditor.getEditor().getCaretModel().addCaretListener((CaretListener)listener);
        VmConnection<Vm> vmConnection = this.connection;
        if (vmConnection == null) {
            Intrinsics.throwNpe();
        }
        Disposer.register((Disposable)((Disposable)vmConnection), (Disposable)new Disposable(this, listener){
            final /* synthetic */ ElementsView this$0;
            final /* synthetic */ ActualDomElementHighlighterOnCaretChange $listener;

            public void dispose() {
                if (this.this$0.getTextEditor$LiveEdit() != null) {
                    TextEditor textEditor = this.this$0.getTextEditor$LiveEdit();
                    if (textEditor == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$listener.dispose(textEditor.getEditor());
                }
            }
            {
                this.this$0 = $outer;
                this.$listener = $captured_local_variable$1;
            }
        });
    }

    private final void setReadOnly(boolean value) {
        TextEditor textEditor = this.textEditor;
        if (textEditor == null) {
            Intrinsics.throwNpe();
        }
        Editor editor = textEditor.getEditor();
        if (editor == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        }
        ((EditorEx)editor).setRendererMode(value);
    }

    public void dispose() {
        this.clearQueueAndState();
        TextEditor editor = this.textEditor;
        if (editor != null) {
            this.textEditor = null;
            XmlFile xmlFile = this.psiFile;
            if (xmlFile == null) {
                Intrinsics.throwNpe();
            }
            StructureViewSelectInTarget.CUSTOM_STRUCTURE_VIEW_KEY.set((UserDataHolder)xmlFile.getViewProvider().getVirtualFile(), null);
            LiveEditElementPreviewProvider.CUSTOM_HIGHLIGHT_EXECUTOR_KEY.set((UserDataHolder)this.psiFile, null);
            this.psiFile = null;
            AppUIUtil.invokeOnEdt((Runnable)new Runnable(this, editor){
                final /* synthetic */ ElementsView this$0;
                final /* synthetic */ TextEditor $editor;

                public final void run() {
                    ElementsView.access$getEditorWrapper$p(this.this$0).removeAll();
                    TextEditorProvider.getInstance().disposeEditor((FileEditor)this.$editor);
                }
                {
                    this.this$0 = elementsView;
                    this.$editor = textEditor;
                }
            });
        }
    }

    private final void clearQueueAndState() {
        this.documentId = -1;
        this.updateQueue.clear();
        this.nodeIdToRangeMarker.clear();
    }

    @NotNull
    public final Project getProject$LiveEdit() {
        return this.project;
    }

    public ElementsView(@Nullable VmConnection<Vm> connection, @NotNull Project project, @Nullable DebuggableFileFinder finder) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.connection = connection;
        this.project = project;
        this.finder = finder;
        this.editorWrapper = new JPanel(new BorderLayout());
        this.nodeIdToRangeMarker = new TIntObjectHashMap();
        this.documentId = -1;
        this.firstDomContentEventFired = new AtomicBoolean();
        this.panelShown = new AtomicBoolean();
        VmConnection<Vm> vmConnection = this.connection;
        if (vmConnection == null) {
            Intrinsics.throwNpe();
        }
        vmConnection.stateChanged((Function1)new Function1<ConnectionState, Unit>(){

            public final void invoke(@NotNull ConnectionState it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (Intrinsics.areEqual((Object)it.getStatus(), (Object)ConnectionStatus.CONNECTED)) {
                    if (this.getCommandProcessor$LiveEdit() == null) {
                        VmConnection vmConnection = connection;
                        if (vmConnection == null) {
                            Intrinsics.throwNpe();
                        }
                        Vm vm = vmConnection.getVm();
                        if (vm == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.wip.WipVm");
                        }
                        this.setCommandProcessor$LiveEdit(((WipVm)vm).getCommandProcessor());
                        WipCommandProcessor wipCommandProcessor = this.getCommandProcessor$LiveEdit();
                        if (wipCommandProcessor == null) {
                            Intrinsics.throwNpe();
                        }
                        wipCommandProcessor.getEventMap().add((EventType)DomContentEventFiredEventData.TYPE, (Function1)new Function1<DomContentEventFiredEventData, Unit>(){

                            public final void invoke(@NotNull DomContentEventFiredEventData it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                if (firstDomContentEventFired.compareAndSet(false, true) && panelShown.get()) {
                                    this.initAndLoadDocument();
                                }
                            }
                        });
                    }
                } else if (Intrinsics.areEqual((Object)it.getStatus(), (Object)ConnectionStatus.WAITING_FOR_CONNECTION) ^ true) {
                    connection = null;
                    finder = null;
                }
            }
        });
        VmConnection<Vm> vmConnection2 = this.connection;
        if (vmConnection2 == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual((Object)vmConnection2.getState().getStatus(), (Object)ConnectionStatus.CONNECTED)) {
            VmConnection<Vm> vmConnection3 = this.connection;
            if (vmConnection3 == null) {
                Intrinsics.throwNpe();
            }
            Vm vm = vmConnection3.getVm();
            if (vm == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.wip.WipVm");
            }
            this.commandProcessor = ((WipVm)vm).getCommandProcessor();
            if (this.firstDomContentEventFired.compareAndSet(false, true) && this.panelShown.get()) {
                this.initAndLoadDocument();
            }
        }
        this.editorWrapper.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(@NotNull AncestorEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (panelShown.compareAndSet(false, true)) {
                    editorWrapper.removeAncestorListener((AncestorListener)((Object)this));
                    if (firstDomContentEventFired.get()) {
                        this.initAndLoadDocument();
                    }
                }
            }
        });
        this.inspectorStructureViewWrapper = new InspectorStructureViewWrapper(this);
        this.updateQueue = new UpdateQueue(this, this.project);
    }

    public static final /* synthetic */ void access$clearQueueAndState(ElementsView $this) {
        $this.clearQueueAndState();
    }

    public static final /* synthetic */ void access$loadDocument(ElementsView $this) {
        $this.loadDocument();
    }

    @NotNull
    public static final /* synthetic */ UpdateQueue access$getUpdateQueue$p(ElementsView $this) {
        return $this.updateQueue;
    }

    public static final /* synthetic */ void access$createEditor(ElementsView $this, @NotNull CharSequence charSequence, @NotNull TIntObjectHashMap nodeIdToOffset) {
        $this.createEditor(charSequence, (TIntObjectHashMap<Segment>)nodeIdToOffset);
    }

    @Nullable
    public static final /* synthetic */ DebuggableFileFinder access$getFinder$p(ElementsView $this) {
        return $this.finder;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/liveEdit/elementsInspector/ElementsView$ElementsRunnerContentProvider;", "Lcom/intellij/javascript/debugger/RunnerContentProvider;", "()V", "registerContent", "", "ui", "Lcom/intellij/execution/ui/RunnerLayoutUi;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "Lorg/jetbrains/debugger/connection/VmConnection;", "Lorg/jetbrains/debugger/Vm;", "tabIdCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "LiveEdit"})
    private static final class ElementsRunnerContentProvider
    implements RunnerContentProvider {
        public void registerContent(@NotNull RunnerLayoutUi ui, @NotNull JavaScriptDebugProcess<? extends VmConnection<Vm>> debugProcess, @NotNull AtomicInteger tabIdCounter) {
            Intrinsics.checkParameterIsNotNull((Object)ui, (String)"ui");
            Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
            Intrinsics.checkParameterIsNotNull((Object)tabIdCounter, (String)"tabIdCounter");
            if (!debugProcess.getElementsInspectorEnabled()) {
                return;
            }
            int tabId = tabIdCounter.incrementAndGet();
            ui.getDefaults().initTabDefaults(tabId, "Elements", HtmlFileType.INSTANCE.getIcon());
            VmConnection vmConnection = debugProcess.getConnection();
            Project project = debugProcess.getSession().getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
            ElementsView elementsView = new ElementsView((VmConnection<Vm>)vmConnection, project, debugProcess.getFinder());
            Disposer.register((Disposable)((Disposable)ui.getContentManager()), (Disposable)elementsView);
            Content structureViewContent = ui.createContent(ElementsViewKt.access$getTEXT_CONTENT_ID$p(), (JComponent)elementsView.inspectorStructureViewWrapper.getComponent(), "Structure", HtmlFileType.INSTANCE.getIcon(), null);
            structureViewContent.setCloseable(false);
            ui.addContent(structureViewContent, tabId, PlaceInGrid.left, false);
            Content elementsViewContent = ui.createContent(ElementsViewKt.access$getSTRUCTURE_CONTENT_ID$p(), (JComponent)elementsView.editorWrapper, "Text", null, null);
            elementsViewContent.setCloseable(false);
            ui.addContent(elementsViewContent, tabId, PlaceInGrid.center, false);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/liveEdit/elementsInspector/ElementsView$ActualDomElementHighlighterOnCaretChange;", "Lcom/jetbrains/liveEdit/highlighting/ElementHighlighterOnCaretChangeBase;", "highlightExecutor", "Lcom/jetbrains/liveEdit/elementsInspector/InspectorElementHighlightExecutor;", "(Lcom/jetbrains/liveEdit/elementsInspector/ElementsView;Lcom/jetbrains/liveEdit/elementsInspector/InspectorElementHighlightExecutor;)V", "run", "", "LiveEdit"})
    private final class ActualDomElementHighlighterOnCaretChange
    extends ElementHighlighterOnCaretChangeBase {
        @Override
        public void run() {
            if (!ElementHighlighter.isHighlightingNeed()) {
                return;
            }
            TextEditor textEditor = ElementsView.this.getTextEditor$LiveEdit();
            if (textEditor == null) {
                Intrinsics.throwNpe();
            }
            this.highlightExecutor.highlight(textEditor.getEditor(), ElementsView.this.getProject$LiveEdit(), null);
        }

        public ActualDomElementHighlighterOnCaretChange(InspectorElementHighlightExecutor highlightExecutor) {
            Intrinsics.checkParameterIsNotNull((Object)highlightExecutor, (String)"highlightExecutor");
            super(highlightExecutor);
        }
    }
}

