/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.elementsInspector;

import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.NotNull;

public class InspectorStructureViewWrapper
implements StructureViewWrapper,
Runnable {
    private final JPanel componentWrapper;
    private StructureView structureView;
    private TextEditor textEditor;
    private int selectionPending;
    private final Alarm updateAlarm;

    public InspectorStructureViewWrapper(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/jetbrains/liveEdit/elementsInspector/InspectorStructureViewWrapper", "<init>"));
        }
        this.selectionPending = -1;
        this.componentWrapper = new JPanel(new BorderLayout());
        this.updateAlarm = new Alarm(parentDisposable);
        this.componentWrapper.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                InspectorStructureViewWrapper.this.componentWrapper.removeAncestorListener((AncestorListener)((Object)this));
                InspectorStructureViewWrapper.this.scheduleRebuild();
            }
        });
        this.componentWrapper.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    InspectorStructureViewWrapper.this.scheduleRebuild();
                }
            }
        });
    }

    @Override
    public void run() {
        this.rebuild();
    }

    private void scheduleRebuild() {
        if (this.updateAlarm.isDisposed()) {
            return;
        }
        this.updateAlarm.cancelAllRequests();
        this.updateAlarm.addRequest((Runnable)this, 500);
    }

    private void rebuild() {
        if (this.textEditor == null) {
            return;
        }
        if (this.structureView == null) {
            StructureViewBuilder structureViewBuilder = this.textEditor.getStructureViewBuilder();
            assert (structureViewBuilder != null);
            this.structureView = structureViewBuilder.createStructureView((FileEditor)this.textEditor, this.textEditor.getEditor().getProject());
            Disposer.register((Disposable)this.textEditor, (Disposable)this.structureView);
            this.componentWrapper.add((Component)this.structureView.getComponent(), "Center");
        }
        if (this.selectionPending != -1) {
            this.structureView.navigateToSelectedElement(this.selectionPending != 0);
        }
    }

    public JPanel getComponent() {
        return this.componentWrapper;
    }

    public void setTextEditor(TextEditor textEditor) {
        this.textEditor = textEditor;
        this.scheduleRebuild();
    }

    public boolean selectCurrentElement(FileEditor fileEditor, VirtualFile file, boolean requestFocus) {
        if (this.componentWrapper.isShowing() && this.updateAlarm.isEmpty()) {
            this.structureView.navigateToSelectedElement(requestFocus);
        } else {
            this.selectionPending = requestFocus ? 1 : 0;
        }
        return true;
    }
}

