/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.highlighting;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.reference.SoftReference;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ElementHighlightExecutor {
    volatile boolean ignoreHighlight;
    protected volatile WeakReference<XmlTag> lastHighlightedTagRef;

    @Nullable
    protected XmlTag findTag(@NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/liveEdit/highlighting/ElementHighlightExecutor", "findTag"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/highlighting/ElementHighlightExecutor", "findTag"));
        }
        return ElementHighlightExecutor.find(editor, project, XmlTag.class);
    }

    @Nullable
    protected static <T extends XmlTagChild> T find(@NotNull Editor editor, @NotNull Project project, @NotNull Class<T> elementClass) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/liveEdit/highlighting/ElementHighlightExecutor", "find"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/highlighting/ElementHighlightExecutor", "find"));
        }
        if (elementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClass", "com/jetbrains/liveEdit/highlighting/ElementHighlightExecutor", "find"));
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        return (T)(psiFile == null ? null : (XmlTagChild)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)editor.getCaretModel().getOffset(), elementClass, (boolean)false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void highlight(@NotNull Editor editor, @NotNull Project project, @Nullable XmlTag tag) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/liveEdit/highlighting/ElementHighlightExecutor", "highlight"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/highlighting/ElementHighlightExecutor", "highlight"));
        }
        if (tag == null) {
            AccessToken token = ReadAction.start();
            try {
                tag = this.findTag(editor, project);
            }
            finally {
                token.finish();
            }
        }
        if (tag == null || tag == this.getLastHighlightedTag()) {
            return;
        }
        this.ignoreHighlight = false;
        this.doHighlight(editor, project, tag);
    }

    protected abstract void doHighlight(Editor var1, Project var2, XmlTag var3);

    public final void hideHighlight(@NotNull Project project, @Nullable XmlTag ifElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/highlighting/ElementHighlightExecutor", "hideHighlight"));
        }
        if (this.lastHighlightedTagRef != null) {
            if (ifElement != null && ifElement != this.getLastHighlightedTag()) {
                return;
            }
            this.lastHighlightedTagRef = null;
            this.doHideHighlight(project, ifElement);
        }
    }

    protected abstract void doHideHighlight(Project var1, @Nullable XmlTag var2);

    @Nullable
    public final XmlTag getLastHighlightedTag() {
        return (XmlTag)SoftReference.dereference(this.lastHighlightedTagRef);
    }

    public final void clearLastHighlightedTag() {
        this.lastHighlightedTagRef = null;
    }
}

