/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.highlighting;

import com.intellij.javascript.debugger.browserConnection.BrowserConnectionManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.liveEdit.ApplicationInspector;
import com.jetbrains.liveEdit.LiveEditManager;
import com.jetbrains.liveEdit.LiveEditOptions;
import com.jetbrains.liveEdit.highlighting.ElementHighlighterCaretListener;
import java.util.concurrent.atomic.AtomicReference;

public class ElementHighlighter
implements Disposable {
    private final AtomicReference<ElementHighlighterCaretListener> listenerRef = new AtomicReference();

    public static ElementHighlighter getInstance() {
        return (ElementHighlighter)ServiceManager.getService(ElementHighlighter.class);
    }

    public static boolean isHighlightingNeed() {
        return LiveEditOptions.getInstance().isElementHighlighting() && BrowserConnectionManager.getInstance().hasConnections() && LiveEditManager.getInstance().isOperable();
    }

    public void setEnabled(boolean value) {
        if (value) {
            ElementHighlighterCaretListener newListener;
            if (this.listenerRef.get() == null && this.listenerRef.compareAndSet(null, newListener = new ElementHighlighterCaretListener())) {
                EditorFactory editorFactory = EditorFactory.getInstance();
                editorFactory.getEventMulticaster().addCaretListener((CaretListener)newListener, (Disposable)newListener);
                editorFactory.addEditorFactoryListener((EditorFactoryListener)newListener, (Disposable)newListener);
            }
        } else if (this.removeListener()) {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                ApplicationInspector.getInstance().hideHighlight(project);
            }
        }
    }

    public void hideHighlighting() {
        ElementHighlighterCaretListener listener = this.listenerRef.get();
        if (listener != null) {
            listener.hideHighlighting();
        }
    }

    public void hideAndIgnoreHighlightUntilElementChanged() {
        ElementHighlighterCaretListener listener = this.listenerRef.get();
        if (listener != null) {
            listener.hideAndIgnoreHighlightUntilElementChanged();
        }
    }

    public void dispose() {
        this.removeListener();
    }

    private boolean removeListener() {
        ElementHighlighterCaretListener listener = this.listenerRef.get();
        if (listener != null && this.listenerRef.compareAndSet(listener, null)) {
            Disposer.dispose((Disposable)listener);
            return true;
        }
        return false;
    }
}

