/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.highlighting;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.xml.util.HtmlUtil;
import com.jetbrains.liveEdit.ApplicationInspector;
import com.jetbrains.liveEdit.LiveEditManager;
import com.jetbrains.liveEdit.highlighting.ElementHighlighter;
import com.jetbrains.liveEdit.highlighting.ElementHighlighterOnCaretChangeBase;
import com.jetbrains.liveEdit.highlighting.LiveEditElementHighlightExecutor;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

final class ElementHighlighterCaretListener
extends ElementHighlighterOnCaretChangeBase
implements EditorFactoryListener,
Disposable {
    volatile WeakReference<Editor> editorRef;

    ElementHighlighterCaretListener() {
        super(new LiveEditElementHighlightExecutor());
    }

    public void dispose() {
    }

    public void editorCreated(@NotNull EditorFactoryEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/liveEdit/highlighting/ElementHighlighterCaretListener", "editorCreated"));
        }
    }

    public void editorReleased(@NotNull EditorFactoryEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/liveEdit/highlighting/ElementHighlighterCaretListener", "editorReleased"));
        }
        if (SoftReference.dereference(this.editorRef) == event.getEditor()) {
            this.editorRef = null;
        }
    }

    @Override
    public void caretPositionChanged(CaretEvent e) {
        Editor editor = e.getEditor();
        if (editor.isOneLineMode()) {
            return;
        }
        Project project = editor.getProject();
        if (project == null || !LiveEditManager.getInstance().isOperableForBrowser(project)) {
            return;
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (file == null || file instanceof LightVirtualFile || !HtmlUtil.isHtmlFile((VirtualFile)file)) {
            return;
        }
        if (SoftReference.dereference(this.editorRef) != editor) {
            this.editorRef = new WeakReference<Editor>(editor);
        }
        super.caretPositionChanged(e);
    }

    void hideHighlighting() {
        final XmlTag tag = this.highlightExecutor.getLastHighlightedTag();
        if (tag != null && !this.highlightExecutor.ignoreHighlight) {
            this.highlightExecutor.clearLastHighlightedTag();
            Project project = (Project)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Project>(){

                public Project compute() {
                    return tag.getProject();
                }
            });
            ApplicationInspector.getInstance().hideHighlight(project);
        }
    }

    void hideAndIgnoreHighlightUntilElementChanged() {
        final XmlTag tag = this.highlightExecutor.getLastHighlightedTag();
        if (tag == null || this.highlightExecutor.ignoreHighlight) {
            return;
        }
        if (!((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return tag.isValid();
            }
        })).booleanValue()) {
            this.highlightExecutor.clearLastHighlightedTag();
            return;
        }
        ApplicationInspector.getInstance().hideHighlight(tag.getProject());
        this.highlightExecutor.ignoreHighlight = true;
    }

    @Override
    public void run() {
        Editor editor = (Editor)SoftReference.dereference(this.editorRef);
        if (editor == null || editor.isDisposed() || !editor.getContentComponent().hasFocus() && !ApplicationManager.getApplication().isUnitTestMode() || !ElementHighlighter.isHighlightingNeed()) {
            return;
        }
        Project project = editor.getProject();
        if (project == null || project.isDisposed()) {
            return;
        }
        this.highlightExecutor.highlight(editor, project, null);
    }
}

