/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.highlighting;

import com.intellij.codeInsight.preview.ElementPreviewProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import com.jetbrains.liveEdit.LiveEditManager;
import com.jetbrains.liveEdit.highlighting.ElementHighlightExecutor;
import com.jetbrains.liveEdit.highlighting.LiveEditElementHighlightExecutor;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LiveEditElementPreviewProvider
implements ElementPreviewProvider {
    public static final Key<ElementHighlightExecutor> CUSTOM_HIGHLIGHT_EXECUTOR_KEY = Key.create((String)"customHighlightExecutor");
    private final ElementHighlightExecutor highlightExecutor = new LiveEditElementHighlightExecutor();

    public final boolean isSupportedFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/liveEdit/highlighting/LiveEditElementPreviewProvider", "isSupportedFile"));
        }
        return HtmlUtil.isHtmlFile((PsiElement)psiFile);
    }

    public final void show(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Point point, boolean keyTriggered) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/liveEdit/highlighting/LiveEditElementPreviewProvider", "show"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/liveEdit/highlighting/LiveEditElementPreviewProvider", "show"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/jetbrains/liveEdit/highlighting/LiveEditElementPreviewProvider", "show"));
        }
        Project project = editor.getProject();
        if (keyTriggered || project == null || !LiveEditManager.getInstance().isOperableForBrowser(project)) {
            return;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
        if (tag == null) {
            return;
        }
        ElementHighlightExecutor customHighlightExecutor = (ElementHighlightExecutor)CUSTOM_HIGHLIGHT_EXECUTOR_KEY.get((UserDataHolder)tag.getContainingFile());
        (customHighlightExecutor == null ? this.highlightExecutor : customHighlightExecutor).highlight(editor, project, tag);
    }

    public final void hide(@Nullable PsiElement element, @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/liveEdit/highlighting/LiveEditElementPreviewProvider", "hide"));
        }
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        this.highlightExecutor.hideHighlight(project, (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false));
    }
}

