/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.jsp;

import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.highlighter.JspxFileType;
import com.intellij.ide.highlighter.NewJspFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.impl.artifacts.ArtifactBySourceFileFinder;
import com.intellij.packaging.impl.ui.actions.PackageFileWorker;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.liveEdit.ApplicationInspector;
import com.jetbrains.liveEdit.FileBasedSynchronizer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class JspSynchronizer
extends FileBasedSynchronizer {
    @Override
    public boolean canHandle(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/jetbrains/liveEdit/jsp/JspSynchronizer", "canHandle"));
        }
        return fileType == NewJspFileType.INSTANCE || fileType == JspxFileType.INSTANCE;
    }

    @Override
    protected void sync(@NotNull List<PsiFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/liveEdit/jsp/JspSynchronizer", "sync"));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/liveEdit/jsp/JspSynchronizer", "lambda$sync$3"));
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            MostlySingularMultiMap projectToFiles = new MostlySingularMultiMap();
            for (PsiFile file : files) {
                VirtualFile virtualFile = file.isValid() ? file.getVirtualFile() : null;
                if (virtualFile == null) continue;
                projectToFiles.add((Object)file.getProject(), (Object)virtualFile);
            }
            if (projectToFiles.isEmpty()) {
                return;
            }
            for (Project project : projectToFiles.keySet()) {
                SmartList result = new SmartList();
                projectToFiles.processForKey((Object)project, arg_0 -> JspSynchronizer.lambda$null$0(project, (List)result, arg_0));
                if (result.isEmpty()) continue;
                PackageFileWorker.startPackagingFiles((Project)project, (List)result, (Artifact[])ArtifactManager.getInstance((Project)project).getArtifacts(), (boolean)false).doWhenDone(() -> JobScheduler.getScheduler().schedule(() -> ApplicationInspector.getInstance().reloadPages(project), 2000L, TimeUnit.MILLISECONDS));
            }
        });
    }

    private static /* synthetic */ boolean lambda$null$0(Project project, List result, VirtualFile file) {
        if (file != null) {
            for (Artifact artifact : ArtifactBySourceFileFinder.getInstance((Project)project).findArtifacts(file)) {
                if (StringUtil.isEmpty((String)artifact.getOutputPath())) continue;
                result.add(file);
                break;
            }
        }
        return true;
    }
}

