/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.rangeValue;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.project.Project;
import com.jetbrains.liveEdit.rangeValue.RangeValueSynchronizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BrowserBackedRangeValueSynchronizer
extends RangeValueSynchronizer {
    private String lastSyncedValue;
    protected final Project project;
    protected boolean dirty;

    protected BrowserBackedRangeValueSynchronizer(Project project) {
        this.project = project;
    }

    @Override
    public final void sync(CharSequence value) {
        this.dirty = true;
        this.doSync(value);
    }

    @Override
    public void sync(@NotNull LookupElement item, @NotNull Lookup lookup, boolean closed) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/liveEdit/rangeValue/BrowserBackedRangeValueSynchronizer", "sync"));
        }
        if (lookup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/jetbrains/liveEdit/rangeValue/BrowserBackedRangeValueSynchronizer", "sync"));
        }
        this.dirty = true;
        String itemLookupString = item.getLookupString();
        if (itemLookupString.equals(this.lastSyncedValue)) {
            return;
        }
        CharSequence value = this.itemToString(item, itemLookupString, lookup, closed);
        if (value != null) {
            this.doSync(value);
            this.lastSyncedValue = itemLookupString;
        }
    }

    @Nullable
    protected CharSequence itemToString(@NotNull LookupElement item, @NotNull String itemLookupString, @NotNull Lookup lookup, boolean closed) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/liveEdit/rangeValue/BrowserBackedRangeValueSynchronizer", "itemToString"));
        }
        if (itemLookupString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemLookupString", "com/jetbrains/liveEdit/rangeValue/BrowserBackedRangeValueSynchronizer", "itemToString"));
        }
        if (lookup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/jetbrains/liveEdit/rangeValue/BrowserBackedRangeValueSynchronizer", "itemToString"));
        }
        return itemLookupString;
    }

    @Nullable
    protected static CharSequence getEffectiveText(@NotNull LookupElement item, @NotNull String itemLookupString, int valueStart, int valueEnd, @NotNull Lookup lookup, boolean closed) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/liveEdit/rangeValue/BrowserBackedRangeValueSynchronizer", "getEffectiveText"));
        }
        if (itemLookupString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemLookupString", "com/jetbrains/liveEdit/rangeValue/BrowserBackedRangeValueSynchronizer", "getEffectiveText"));
        }
        if (lookup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/jetbrains/liveEdit/rangeValue/BrowserBackedRangeValueSynchronizer", "getEffectiveText"));
        }
        if (closed) {
            return lookup.getEditor().getDocument().getImmutableCharSequence().subSequence(valueStart, valueEnd);
        }
        int caretOffset = lookup.getEditor().getCaretModel().getOffset();
        int end = caretOffset - ((LookupImpl)lookup).getPrefixLength(item);
        if (end <= valueStart && valueEnd <= caretOffset) {
            return itemLookupString;
        }
        StringBuilder builder = new StringBuilder();
        CharSequence chars = lookup.getEditor().getDocument().getImmutableCharSequence();
        if (end > valueStart) {
            builder.append(chars, valueStart, end);
        }
        builder.append(itemLookupString);
        if (valueEnd > caretOffset) {
            builder.append(chars, caretOffset, valueEnd);
        }
        return builder;
    }

    protected abstract void doSync(@NotNull CharSequence var1);

    @Override
    public void revert() {
        if (this.dirty) {
            this.lastSyncedValue = null;
            this.doRevert();
        }
    }

    protected abstract void doRevert();
}

