/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.rangeValue;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.Function;
import com.jetbrains.liveEdit.ApplicationInspector;
import com.jetbrains.liveEdit.CssPsiUtil;
import com.jetbrains.liveEdit.rangeValue.BrowserBackedRangeValueSynchronizer;
import com.jetbrains.liveEdit.rangeValue.RangeValueSynchronizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RangeValueSynchronizerFactory<T> {
    public static final ExtensionPointName<RangeValueSynchronizerFactory<RangeValueSynchronizer>> EP_NAME = ExtensionPointName.create((String)"com.jetbrains.liveEdit.rangeValueSynchronizerFactory");

    @Nullable
    public abstract T create(@NotNull FileType var1, @NotNull PsiElement var2, @NotNull PsiFile var3);

    @Nullable
    public static <F extends RangeValueSynchronizerFactory<S>, S> S find(@NotNull PsiElement element, @NotNull PsiFile file, @NotNull ExtensionPointName<F> ep) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/liveEdit/rangeValue/RangeValueSynchronizerFactory", "find"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/rangeValue/RangeValueSynchronizerFactory", "find"));
        }
        if (ep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ep", "com/jetbrains/liveEdit/rangeValue/RangeValueSynchronizerFactory", "find"));
        }
        FileType fileType = file.getViewProvider().getFileType();
        for (RangeValueSynchronizerFactory factory : (RangeValueSynchronizerFactory[])ep.getExtensions()) {
            Object synchronizer = factory.create(fileType, element, file);
            if (synchronizer == null) continue;
            return (S)synchronizer;
        }
        return null;
    }

    @Nullable
    public static <R> R applyAndGet(PsiElement element, PsiFile file, Function<RangeValueSynchronizer, R> manager) {
        RangeValueSynchronizer synchronizer = (RangeValueSynchronizer)RangeValueSynchronizerFactory.find(element, file, EP_NAME);
        return (R)(synchronizer != null ? manager.fun((Object)synchronizer) : null);
    }

    public static class Css
    extends RangeValueSynchronizerFactory<RangeValueSynchronizer> {
        protected static final Logger LOG = Logger.getInstance(Css.class);

        @Nullable
        protected static CssDeclaration findCssDeclaration(PsiElement element) {
            CssDeclaration declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, CssDeclaration.class);
            if (declaration == null && element instanceof PsiWhiteSpace && element.getPrevSibling() instanceof CssDeclaration) {
                declaration = (CssDeclaration)element.getPrevSibling();
            }
            return declaration;
        }

        @Override
        @Nullable
        public final RangeValueSynchronizer create(@NotNull FileType fileType, @NotNull PsiElement element, @NotNull PsiFile file) {
            if (fileType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/jetbrains/liveEdit/rangeValue/RangeValueSynchronizerFactory$Css", "create"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/liveEdit/rangeValue/RangeValueSynchronizerFactory$Css", "create"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/rangeValue/RangeValueSynchronizerFactory$Css", "create"));
            }
            if (fileType != CssFileType.INSTANCE) {
                return null;
            }
            CssDeclaration declaration = Css.findCssDeclaration(element);
            if (declaration == null) {
                return null;
            }
            CssRuleset ruleset = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)declaration, CssRuleset.class);
            if (ruleset == null) {
                LOG.warn("cannot find css ruleset for " + declaration.getText());
                return null;
            }
            if (ruleset.getSelectorList() == null) {
                LOG.warn("invalid ruleset, cannot find selector list " + ruleset.getText());
                return null;
            }
            return this.create(file, declaration);
        }

        @Nullable
        protected RangeValueSynchronizer create(@NotNull PsiFile file, @NotNull CssDeclaration declaration) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/rangeValue/RangeValueSynchronizerFactory$Css", "create"));
            }
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/jetbrains/liveEdit/rangeValue/RangeValueSynchronizerFactory$Css", "create"));
            }
            return new DeclarationValueSynchronizer(file, declaration);
        }

        private static class DeclarationValueSynchronizer
        extends BrowserBackedRangeValueSynchronizer {
            private final VirtualFile file;
            private final CssDeclaration declaration;
            private final boolean isImportant;

            public DeclarationValueSynchronizer(@NotNull PsiFile file, @NotNull CssDeclaration declaration) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/rangeValue/RangeValueSynchronizerFactory$Css$DeclarationValueSynchronizer", "<init>"));
                }
                if (declaration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/jetbrains/liveEdit/rangeValue/RangeValueSynchronizerFactory$Css$DeclarationValueSynchronizer", "<init>"));
                }
                super(file.getProject());
                this.file = file.getOriginalFile().getVirtualFile();
                this.declaration = declaration;
                this.isImportant = declaration.isImportant();
            }

            private void setProperty(@Nullable CharSequence value) {
                ApplicationInspector.getInstance().setCssProperty(this.project, this.file, this.declaration, value);
            }

            @Override
            protected void doRevert() {
                if (this.declaration.isValid()) {
                    this.setProperty(CssPsiUtil.getValue(this.declaration));
                }
            }

            @Override
            @Nullable
            protected CharSequence itemToString(@NotNull LookupElement item, @NotNull String itemLookupString, @NotNull Lookup lookup, boolean closed) {
                PsiElement nameElement;
                if (item == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/liveEdit/rangeValue/RangeValueSynchronizerFactory$Css$DeclarationValueSynchronizer", "itemToString"));
                }
                if (itemLookupString == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemLookupString", "com/jetbrains/liveEdit/rangeValue/RangeValueSynchronizerFactory$Css$DeclarationValueSynchronizer", "itemToString"));
                }
                if (lookup == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/jetbrains/liveEdit/rangeValue/RangeValueSynchronizerFactory$Css$DeclarationValueSynchronizer", "itemToString"));
                }
                CssTermList value = this.declaration.getValue();
                if (value == null) {
                    return itemLookupString;
                }
                if (PsiTreeUtil.hasErrorElements((PsiElement)this.declaration) && ((nameElement = this.declaration.getPropertyNameElement()) == null || nameElement.getNextSibling() instanceof PsiErrorElement)) {
                    return null;
                }
                int startOffset = value.getNode().getStartOffset();
                return DeclarationValueSynchronizer.getEffectiveText(item, itemLookupString, startOffset, startOffset + value.getTextLength(), lookup, closed);
            }

            @Override
            protected void doSync(@NotNull CharSequence item) {
                if (item == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/liveEdit/rangeValue/RangeValueSynchronizerFactory$Css$DeclarationValueSynchronizer", "doSync"));
                }
                this.setProperty(CssPsiUtil.prepareValueForChrome(item, this.isImportant));
            }
        }
    }

    public static abstract class Html<T>
    extends RangeValueSynchronizerFactory<T> {
        @Nullable
        protected static Pair<XmlAttribute, CssDeclaration> findAttributeAndCssDeclaration(PsiElement element) {
            if (element.getLanguage().isKindOf(JavaScriptFileType.INSTANCE.getLanguage())) {
                return null;
            }
            CssDeclaration cssDeclaration = (CssDeclaration)PsiTreeUtil.getPrevSiblingOfType((PsiElement)element, CssDeclaration.class);
            if (cssDeclaration != null) {
                XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)cssDeclaration, XmlAttribute.class);
                return attribute == null ? null : Pair.create((Object)attribute, (Object)cssDeclaration);
            }
            PsiElement parent = element;
            while (true) {
                if (parent instanceof CssDeclaration) {
                    cssDeclaration = (CssDeclaration)parent;
                } else if (cssDeclaration == null && parent instanceof CssBlock) {
                    cssDeclaration = (CssDeclaration)PsiTreeUtil.getPrevSiblingOfType((PsiElement)parent, CssDeclaration.class);
                    if (cssDeclaration == null) {
                        return null;
                    }
                } else {
                    if (parent instanceof XmlAttribute) break;
                    if (parent == null || parent instanceof XmlTag || parent instanceof XmlText) {
                        return null;
                    }
                }
                parent = parent.getParent();
            }
            XmlAttribute attribute = (XmlAttribute)parent;
            return Pair.create((Object)attribute, (Object)cssDeclaration);
        }

        @Override
        @Nullable
        public final T create(@NotNull FileType fileType, @NotNull PsiElement element, @NotNull PsiFile file) {
            if (fileType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/jetbrains/liveEdit/rangeValue/RangeValueSynchronizerFactory$Html", "create"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/liveEdit/rangeValue/RangeValueSynchronizerFactory$Html", "create"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/rangeValue/RangeValueSynchronizerFactory$Html", "create"));
            }
            if (fileType != HtmlFileType.INSTANCE) {
                return null;
            }
            Pair<XmlAttribute, CssDeclaration> attributeAndCssDeclaration = Html.findAttributeAndCssDeclaration(element);
            return attributeAndCssDeclaration == null ? null : (T)this.create(file, (XmlAttribute)attributeAndCssDeclaration.first, (CssDeclaration)attributeAndCssDeclaration.second);
        }

        @Nullable
        protected abstract T create(@NotNull PsiFile var1, @NotNull XmlAttribute var2, @Nullable CssDeclaration var3);
    }
}

