/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.update;

import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.liveEdit.ApplicationInspector;
import com.jetbrains.liveEdit.FileBasedSynchronizer;
import com.jetbrains.liveEdit.InSingleFileBasedSynchronizer;
import com.jetbrains.liveEdit.LiveEditBundle;
import com.jetbrains.liveEdit.LiveEditOptions;
import com.jetbrains.liveEdit.UpdatePolicy;
import com.jetbrains.liveEdit.update.ScriptHotSwapTask;
import com.jetbrains.liveEdit.update.UpdateConfiguration;
import com.jetbrains.liveEdit.update.UpdateConfigurationProvider;
import com.jetbrains.liveEdit.update.UpdateScriptResult;
import com.jetbrains.liveEdit.update.UpdateState;
import java.util.List;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptManager;
import org.jetbrains.debugger.Vm;
import org.jetbrains.v8.HotSwapScriptManager;
import org.jetbrains.v8.liveEditProtocol.ScriptLiveChangeResult;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a3\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u00a2\u0006\u0002\u0010\u0013\u001a\u001d\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u00042\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\f\u001a\u00020\r\u001a\u0013\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u00042\u0006\u0010\f\u001a\u00020\r\u001a*\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002\u001a\u0018\u0010\u001b\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\"\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002\u001a\u0018\u0010\"\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u000e\u0010#\u001a\u00020!2\u0006\u0010\f\u001a\u00020\r\u001a \u0010$\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002\u001a\u000e\u0010)\u001a\u00020!2\u0006\u0010\f\u001a\u00020\r\u001a>\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010'\u001a\u00020(H\u0002\u001a\"\u00102\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0019\u0010\u0007\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u00063"}, d2={"DISABLE_AUTO_RESTART_IF_HOTSWAP_FAILED_NOTIFICATION_LISTENER", "Lcom/intellij/notification/NotificationListener$Adapter;", "MINOR_NOTIFICATION_GROUP", "Lcom/intellij/notification/NotificationGroup;", "Lorg/jetbrains/annotations/NotNull;", "getMINOR_NOTIFICATION_GROUP", "()Lcom/intellij/notification/NotificationGroup;", "NOTIFICATION_GROUP", "getNOTIFICATION_GROUP", "collectSources", "", "", "debugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "synchronizer", "Lcom/jetbrains/liveEdit/InSingleFileBasedSynchronizer;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/xdebugger/XDebugProcess;Lcom/jetbrains/liveEdit/InSingleFileBasedSynchronizer;Ljava/util/List;)[Ljava/lang/CharSequence;", "getShortenedFilePath", "", "file", "getUpdateConfiguration", "Lcom/jetbrains/liveEdit/update/UpdateConfiguration;", "getUpdatePolicy", "Lcom/jetbrains/liveEdit/UpdatePolicy;", "inform", "Lcom/intellij/notification/Notification;", "notificationGroup", "message", "listener", "Lcom/intellij/notification/NotificationListener;", "", "notifyFileHasErrors", "notifyNothingToUpdate", "processResult", "result", "Lorg/jetbrains/v8/liveEditProtocol/ScriptLiveChangeResult;", "state", "Lcom/jetbrains/liveEdit/update/UpdateState;", "restart", "setScriptSource", "Lorg/jetbrains/concurrency/Promise;", "Lcom/jetbrains/liveEdit/update/UpdateScriptResult;", "text", "script", "Lorg/jetbrains/debugger/Script;", "vm", "Lorg/jetbrains/debugger/Vm;", "warn", "LiveEdit"})
public final class ApplicationUpdaterKt {
    @NotNull
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"LiveEdit", (String)ToolWindowId.DEBUG);
    @NotNull
    private static final NotificationGroup MINOR_NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup((String)"LiveEdit Minor");
    private static final NotificationListener.Adapter DISABLE_AUTO_RESTART_IF_HOTSWAP_FAILED_NOTIFICATION_LISTENER = new NotificationListener.Adapter(){

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            notification.expire();
            LiveEditOptions.getInstance().setRestartIfHotSwapFailed(false);
        }
    };

    @NotNull
    public static final NotificationGroup getNOTIFICATION_GROUP() {
        return NOTIFICATION_GROUP;
    }

    @NotNull
    public static final NotificationGroup getMINOR_NOTIFICATION_GROUP() {
        return MINOR_NOTIFICATION_GROUP;
    }

    @NotNull
    public static final UpdatePolicy getUpdatePolicy(@NotNull XDebugProcess debugProcess) {
        Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
        Object object = ApplicationUpdaterKt.getUpdateConfiguration(debugProcess);
        if (object == null || (object = object.getPolicy()) == null) {
            object = UpdatePolicy.DISABLED;
        }
        return object;
    }

    @Nullable
    public static final UpdateConfiguration getUpdateConfiguration(@NotNull XDebugProcess debugProcess) {
        Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
        UpdateConfigurationProvider[] updateConfigurationProviderArray = (UpdateConfigurationProvider[])UpdateConfigurationProvider.EP_NAME.getExtensions();
        for (int i = 0; i < updateConfigurationProviderArray.length; ++i) {
            UpdateConfigurationProvider provider = updateConfigurationProviderArray[i];
            UpdateConfiguration configuration = provider.getConfiguration(debugProcess);
            if (configuration == null) continue;
            return configuration;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Promise<UpdateScriptResult> setScriptSource(CharSequence text, Script script, Vm vm, VirtualFile file, XDebugProcess debugProcess, UpdateState state) {
        AsyncPromise<UpdateScriptResult> asyncPromise;
        Map<VirtualFile, ScriptHotSwapTask> map = state.getScriptHotSwapTaskMap$LiveEdit();
        synchronized (map) {
            ScriptHotSwapTask task = state.getScriptHotSwapTaskMap$LiveEdit().get(file);
            if (task != null) {
                if (Intrinsics.areEqual((Object)task.getText(), (Object)text) ^ true) {
                    task.setText(text);
                    task.setNextTask((Function0<Unit>)((Function0)new Function0<Unit>(state, file, text, script, vm, debugProcess){
                        final /* synthetic */ UpdateState $state$inlined;
                        final /* synthetic */ VirtualFile $file$inlined;
                        final /* synthetic */ CharSequence $text$inlined;
                        final /* synthetic */ Script $script$inlined;
                        final /* synthetic */ Vm $vm$inlined;
                        final /* synthetic */ XDebugProcess $debugProcess$inlined;
                        {
                            this.$state$inlined = updateState;
                            this.$file$inlined = virtualFile;
                            this.$text$inlined = charSequence;
                            this.$script$inlined = script;
                            this.$vm$inlined = vm;
                            this.$debugProcess$inlined = xDebugProcess;
                            super(0);
                        }

                        public final void invoke() {
                            ApplicationUpdaterKt.access$setScriptSource(this.$text$inlined, this.$script$inlined, this.$vm$inlined, this.$file$inlined, this.$debugProcess$inlined, this.$state$inlined);
                        }
                    }));
                }
                Promise promise = (Promise)task.getCallback();
                return promise;
            }
            task = new ScriptHotSwapTask(text);
            state.getScriptHotSwapTaskMap$LiveEdit().put(file, task);
            AsyncPromise<UpdateScriptResult> asyncPromise2 = task.getCallback();
            asyncPromise = asyncPromise2;
        }
        AsyncPromise<UpdateScriptResult> promise = asyncPromise;
        ScriptManager scriptManager = vm.getScriptManager();
        if (scriptManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.v8.HotSwapScriptManager");
        }
        Promise sourceOnRemote = ((HotSwapScriptManager)scriptManager).setSourceOnRemote(script, text, false);
        sourceOnRemote.done((Consumer)new Consumer<ScriptLiveChangeResult>(file, state){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ UpdateState $state;

            public final void consume(ScriptLiveChangeResult it) {
                ScriptLiveChangeResult scriptLiveChangeResult = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)scriptLiveChangeResult, (String)"it");
                ApplicationUpdaterKt.access$processResult(this.$file, scriptLiveChangeResult, this.$state);
            }
            {
                this.$file = virtualFile;
                this.$state = updateState;
            }
        }).rejected((Consumer)new Consumer<Throwable>(state, file, debugProcess){
            final /* synthetic */ UpdateState $state;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ XDebugProcess $debugProcess;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void consume(Throwable error) {
                block7: {
                    ScriptHotSwapTask scriptHotSwapTask;
                    Map<VirtualFile, ScriptHotSwapTask> map = this.$state.getScriptHotSwapTaskMap$LiveEdit();
                    synchronized (map) {
                        ScriptHotSwapTask scriptHotSwapTask2 = this.$state.getScriptHotSwapTaskMap$LiveEdit().remove(this.$file);
                        if (scriptHotSwapTask2 == null) {
                            Intrinsics.throwNpe();
                        }
                        scriptHotSwapTask = scriptHotSwapTask2;
                    }
                    ScriptHotSwapTask task = scriptHotSwapTask;
                    String message = error.getMessage();
                    if (message != null && StringsKt.indexOf$default((CharSequence)message, (String)"Script not found", (int)0, (boolean)false, (int)6, null) >= 0) {
                        task.getCallback().setResult((Object)new UpdateScriptResult(this.$file, ScriptLiveChangeResult.ChangeStatus.CHANGED, message));
                        return;
                    }
                    AsyncPromise<UpdateScriptResult> asyncPromise = task.getCallback();
                    Throwable throwable = error;
                    Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"error");
                    asyncPromise.setError(throwable);
                    CharSequence charSequence = message;
                    if (!(charSequence == null || charSequence.length() == 0)) {
                        String string = message;
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        ApplicationUpdaterKt.warn(string, this.$debugProcess, null);
                    }
                    Function0<Unit> function0 = task.getNextTask();
                    if (function0 == null) break block7;
                    Unit cfr_ignored_0 = (Unit)function0.invoke();
                }
            }
            {
                this.$state = updateState;
                this.$file = virtualFile;
                this.$debugProcess = xDebugProcess;
            }
        });
        return (Promise)promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void processResult(VirtualFile file, ScriptLiveChangeResult result, UpdateState state) {
        block5: {
            ScriptHotSwapTask scriptHotSwapTask;
            Map<VirtualFile, ScriptHotSwapTask> map = state.getScriptHotSwapTaskMap$LiveEdit();
            synchronized (map) {
                ScriptHotSwapTask scriptHotSwapTask2 = state.getScriptHotSwapTaskMap$LiveEdit().remove(file);
                if (scriptHotSwapTask2 == null) {
                    Intrinsics.throwNpe();
                }
                scriptHotSwapTask = scriptHotSwapTask2;
            }
            ScriptHotSwapTask task = scriptHotSwapTask;
            task.getCallback().setResult((Object)new UpdateScriptResult(file, result.getStatus(), result.getStatusExplanation()));
            if (!(Intrinsics.areEqual((Object)result.getStatus(), (Object)ScriptLiveChangeResult.ChangeStatus.CHANGED) ^ true)) break block5;
            result.doRecommended();
            Function0<Unit> function0 = task.getNextTask();
            if (function0 != null) {
                Unit cfr_ignored_0 = (Unit)function0.invoke();
            }
        }
    }

    public static final void notifyNothingToUpdate(@NotNull XDebugProcess debugProcess) {
        Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
        String string = LiveEditBundle.message("nothing.to.update", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"LiveEditBundle.message(\"nothing.to.update\")");
        ApplicationUpdaterKt.inform(string, debugProcess);
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence[] collectSources(XDebugProcess debugProcess, InSingleFileBasedSynchronizer synchronizer, List<? extends VirtualFile> files) {
        void warnings;
        FileManager psiManager = PsiManagerEx.getInstanceEx((Project)debugProcess.getSession().getProject()).getFileManager();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        CharSequence[] sources = (CharSequence[])ApplicationManager.getApplication().runReadAction(new Computable<T>(files, psiManager, synchronizer, (Ref.ObjectRef)warnings, debugProcess){
            final /* synthetic */ List $files$inlined;
            final /* synthetic */ FileManager $psiManager$inlined;
            final /* synthetic */ InSingleFileBasedSynchronizer $synchronizer$inlined;
            final /* synthetic */ Ref.ObjectRef $warnings$inlined;
            final /* synthetic */ XDebugProcess $debugProcess$inlined;
            {
                this.$files$inlined = list;
                this.$psiManager$inlined = fileManager;
                this.$synchronizer$inlined = inSingleFileBasedSynchronizer;
                this.$warnings$inlined = objectRef;
                this.$debugProcess$inlined = xDebugProcess;
            }

            /*
             * Unable to fully structure code
             */
            public final T compute() {
                block10: {
                    size$iv = this.$files$inlined.size();
                    result$iv = new CharSequence[size$iv];
                    var3_3 = 0;
                    var4_4 = size$iv - 1;
                    if (var3_3 > var4_4) break block10;
                    do {
                        block11: {
                            var5_5 = ++i$iv;
                            var6_6 = i$iv;
                            var7_7 = result$iv;
                            file = (VirtualFile)this.$files$inlined.get((int)i);
                            text = null;
                            psiFile = this.$psiManager$inlined.getCachedPsiFile(file);
                            if (psiFile == null) break block11;
                            text = this.$synchronizer$inlined.getFileTextIfValidAndRemoveRelatedPendingElements(psiFile);
                            ** GOTO lbl31
                        }
                        psiFile = this.$psiManager$inlined.findFile(file);
                        if (psiFile == null) {
                            if ((List)this.$warnings$inlined.element == null) {
                                this.$warnings$inlined.element = (List)new SmartList();
                            }
                            v0 = (List)this.$warnings$inlined.element;
                            if (v0 == null) {
                                Intrinsics.throwNpe();
                            }
                            v0.add("Cannot update " + ApplicationUpdaterKt.access$getShortenedFilePath(file, this.$debugProcess$inlined) + ": internal error, cannot find PSI file");
                            v1 = "";
                        } else {
                            if (!PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)psiFile))) {
                                text = FileBasedSynchronizer.getChars(psiFile);
                            }
lbl31:
                            // 4 sources

                            if (text == null) {
                                if ((List)this.$warnings$inlined.element == null) {
                                    this.$warnings$inlined.element = (List)new SmartList();
                                }
                                v2 = (List)this.$warnings$inlined.element;
                                if (v2 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v2.add("Cannot update " + ApplicationUpdaterKt.access$getShortenedFilePath(file, this.$debugProcess$inlined) + ": contains syntax errors");
                                v1 = "";
                            } else {
                                v1 = text;
                            }
                        }
                        var7_7[var6_6] = var11_11 = v1;
                    } while (i$iv != var4_4);
                }
                return var2_2;
            }
        });
        if ((List)warnings.element == null) {
            return sources;
        }
        List list = (List)warnings.element;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        for (String warning : list) {
            ApplicationUpdaterKt.warn(warning, debugProcess, null);
        }
        return null;
    }

    private static final void notifyFileHasErrors(VirtualFile file, XDebugProcess debugProcess) {
        ApplicationUpdaterKt.warn("Cannot update " + ApplicationUpdaterKt.getShortenedFilePath(file, debugProcess) + ": contains syntax errors", debugProcess, null);
    }

    private static final String getShortenedFilePath(VirtualFile file, XDebugProcess debugProcess) {
        return JsFileUtil.getShortenedFilePath((VirtualFile)file, (Project)debugProcess.getSession().getProject());
    }

    private static final void inform(String message, XDebugProcess debugProcess) {
        ApplicationUpdaterKt.inform(message, debugProcess, null);
    }

    private static final Notification inform(String message, XDebugProcess debugProcess, NotificationListener listener) {
        NotificationGroup notificationGroup = NOTIFICATION_GROUP;
        Intrinsics.checkExpressionValueIsNotNull((Object)notificationGroup, (String)"NOTIFICATION_GROUP");
        return ApplicationUpdaterKt.inform(notificationGroup, message, debugProcess, listener);
    }

    private static final Notification inform(NotificationGroup notificationGroup, String message, XDebugProcess debugProcess, NotificationListener listener) {
        XDebugSession session = debugProcess.getSession();
        Notification notification = notificationGroup.createNotification("", session.getSessionName() + ": " + message, NotificationType.INFORMATION, listener);
        notification.notify(session.getProject());
        Notification notification2 = notification;
        Intrinsics.checkExpressionValueIsNotNull((Object)notification2, (String)"notification");
        return notification2;
    }

    @NotNull
    public static final Notification warn(@NotNull String message, @NotNull XDebugProcess debugProcess, @Nullable NotificationListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
        XDebugSession session = debugProcess.getSession();
        Notification notification = NOTIFICATION_GROUP.createNotification("", session.getSessionName() + ": " + message, NotificationType.WARNING, listener);
        if (listener != null) {
            notification.setImportant(true);
        }
        notification.notify(session.getProject());
        Notification notification2 = notification;
        Intrinsics.checkExpressionValueIsNotNull((Object)notification2, (String)"notification");
        return notification2;
    }

    public static final void restart(@NotNull XDebugProcess debugProcess) {
        Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
        UpdateConfiguration updateConfiguration = ApplicationUpdaterKt.getUpdateConfiguration(debugProcess);
        if (updateConfiguration == null) {
            Intrinsics.throwNpe();
        }
        UpdateConfiguration updateConfiguration2 = updateConfiguration;
        ApplicationInspector.getInstance().clearUpdateState(debugProcess);
        updateConfiguration2.restart(debugProcess);
    }

    @NotNull
    public static final /* synthetic */ Promise access$setScriptSource(@NotNull CharSequence text, @NotNull Script script, @NotNull Vm vm, @NotNull VirtualFile file, @NotNull XDebugProcess debugProcess, @NotNull UpdateState state) {
        return ApplicationUpdaterKt.setScriptSource(text, script, vm, file, debugProcess, state);
    }

    public static final /* synthetic */ void access$notifyFileHasErrors(@NotNull VirtualFile file, @NotNull XDebugProcess debugProcess) {
        ApplicationUpdaterKt.notifyFileHasErrors(file, debugProcess);
    }

    @Nullable
    public static final /* synthetic */ CharSequence[] access$collectSources(@NotNull XDebugProcess debugProcess, @NotNull InSingleFileBasedSynchronizer synchronizer, @NotNull List files) {
        return ApplicationUpdaterKt.collectSources(debugProcess, synchronizer, files);
    }

    public static final /* synthetic */ void access$inform(@NotNull String message, @NotNull XDebugProcess debugProcess) {
        ApplicationUpdaterKt.inform(message, debugProcess);
    }

    @NotNull
    public static final /* synthetic */ NotificationListener.Adapter access$getDISABLE_AUTO_RESTART_IF_HOTSWAP_FAILED_NOTIFICATION_LISTENER$p() {
        return DISABLE_AUTO_RESTART_IF_HOTSWAP_FAILED_NOTIFICATION_LISTENER;
    }

    public static final /* synthetic */ void access$processResult(@NotNull VirtualFile file, @NotNull ScriptLiveChangeResult result, @NotNull UpdateState state) {
        ApplicationUpdaterKt.processResult(file, result, state);
    }

    @NotNull
    public static final /* synthetic */ String access$getShortenedFilePath(@NotNull VirtualFile file, @NotNull XDebugProcess debugProcess) {
        return ApplicationUpdaterKt.getShortenedFilePath(file, debugProcess);
    }
}

