/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.update;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.liveEdit.ApplicationInspectorImpl;
import com.jetbrains.liveEdit.ApplicationInspectorImplKt;
import com.jetbrains.liveEdit.update.ListAsyncValueLoader;
import com.jetbrains.liveEdit.update.RemoteCssStyleSheet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.css.CSSStyleSheetHeaderValue;
import org.jetbrains.wip.protocol.css.StyleSheetAddedEventData;
import org.jetbrains.wip.protocol.css.StyleSheetChangedEventData;
import org.jetbrains.wip.protocol.css.StyleSheetRemovedEventData;
import org.jetbrains.wip.protocol.page.FrameDetachedEventData;
import org.jetbrains.wip.protocol.page.FrameNavigatedEventData;

public class CssEventHandler {
    private final ApplicationInspectorImpl inspector;
    private final Project project;

    public CssEventHandler(@NotNull ApplicationInspectorImpl inspector, @NotNull Project project) {
        if (inspector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspector", "com/jetbrains/liveEdit/update/CssEventHandler", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/update/CssEventHandler", "<init>"));
        }
        this.inspector = inspector;
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(Object event, WipVm vm) {
        ListAsyncValueLoader loader;
        Map<WipVm, ListAsyncValueLoader> map = this.inspector.getVmToStylesheetsCache();
        synchronized (map) {
            loader = this.inspector.getVmToStylesheetsCache().get(vm);
            if (loader == null) {
                return;
            }
        }
        List<RemoteCssStyleSheet> stylesheets = loader.getStylesheets();
        if (event instanceof StyleSheetAddedEventData) {
            CSSStyleSheetHeaderValue styleSheetInfo = ((StyleSheetAddedEventData)event).header();
            if (StringUtil.isEmpty((String)styleSheetInfo.sourceURL())) {
                ApplicationInspectorImplKt.getLOG().warn("CSS " + styleSheetInfo.styleSheetId() + " has empty source URL, sourcemap URL " + styleSheetInfo.getSourceMapURL());
            } else {
                Url parsed = Urls.parseEncoded((String)styleSheetInfo.sourceURL());
                if (parsed != null) {
                    List<RemoteCssStyleSheet> list = stylesheets;
                    synchronized (list) {
                        RemoteCssStyleSheet styleSheet = new RemoteCssStyleSheet(styleSheetInfo, parsed, vm.getCommandProcessor(), this.project);
                        stylesheets.add(styleSheet);
                    }
                }
            }
        } else {
            if (event instanceof StyleSheetRemovedEventData) {
                String styleSheetId = ((StyleSheetRemovedEventData)event).styleSheetId();
                List<RemoteCssStyleSheet> list = stylesheets;
                synchronized (list) {
                    Iterator<RemoteCssStyleSheet> iterator = stylesheets.iterator();
                    while (iterator.hasNext()) {
                        RemoteCssStyleSheet stylesheet = iterator.next();
                        if (!stylesheet.descriptor.styleSheetId().equals(styleSheetId)) continue;
                        iterator.remove();
                        break;
                    }
                }
            }
            if (event instanceof StyleSheetChangedEventData) {
                String styleSheetId = ((StyleSheetChangedEventData)event).styleSheetId();
                List<RemoteCssStyleSheet> list = stylesheets;
                synchronized (list) {
                    for (RemoteCssStyleSheet stylesheet : stylesheets) {
                        if (!stylesheet.descriptor.styleSheetId().equals(styleSheetId)) continue;
                        stylesheet.onChanged();
                        break;
                    }
                }
            }
            String frameId = event instanceof FrameDetachedEventData ? ((FrameDetachedEventData)event).frameId() : ((FrameNavigatedEventData)event).frame().id();
            List<RemoteCssStyleSheet> list = stylesheets;
            synchronized (list) {
                Iterator<RemoteCssStyleSheet> iterator = stylesheets.iterator();
                while (iterator.hasNext()) {
                    RemoteCssStyleSheet stylesheet = iterator.next();
                    if (!stylesheet.descriptor.frameId().equals(frameId)) continue;
                    iterator.remove();
                }
            }
        }
    }
}

