/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.update;

import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.liveEdit.ApplicationInspectorImplKt;
import com.jetbrains.liveEdit.update.RemoteCssStyleSheet;
import com.jetbrains.liveEdit.update.SetSourceExecutor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.protocol.WipRequest;
import org.jetbrains.wip.protocol.css.CSSKt;
import org.jetbrains.wip.protocol.css.SetStyleTextsResult;
import org.jetbrains.wip.protocol.css.SourceRange;
import org.jetbrains.wip.protocol.css.StyleDeclarationEdit;

public final class CssHelper {
    @NotNull
    public static SetSourceExecutor createSetSourceExecutor(final @NotNull List<RemoteCssStyleSheet> styleSheets, final @NotNull JavaScriptDebugProcess<? extends VmConnection> debugProcess) {
        if (styleSheets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleSheets", "com/jetbrains/liveEdit/update/CssHelper", "createSetSourceExecutor"));
        }
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/liveEdit/update/CssHelper", "createSetSourceExecutor"));
        }
        SetSourceExecutor setSourceExecutor = new SetSourceExecutor(){

            @Override
            @NotNull
            public List<Promise<?>> execute(@NotNull VirtualFile file, @NotNull CharSequence source) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/update/CssHelper$1", "execute"));
                }
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/liveEdit/update/CssHelper$1", "execute"));
                }
                SmartList callbacks = null;
                for (RemoteCssStyleSheet styleSheet : styleSheets) {
                    if (!CssHelper.sourceEquals(file, styleSheet.url, styleSheet.project, debugProcess.getFinder())) continue;
                    if (callbacks == null) {
                        callbacks = new SmartList();
                    }
                    callbacks.add(styleSheet.commandProcessor.send((Request)CSSKt.SetStyleSheetText((CharSequence)styleSheet.descriptor.styleSheetId(), (CharSequence)source)));
                    styleSheet.removeIncrementalUpdates();
                }
                List<Object> list = callbacks == null ? Collections.emptyList() : callbacks;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/update/CssHelper$1", "execute"));
                }
                return list;
            }
        };
        if (setSourceExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/update/CssHelper", "createSetSourceExecutor"));
        }
        return setSourceExecutor;
    }

    private static boolean sourceEquals(@NotNull VirtualFile file, @NotNull Url remoteUrl, @NotNull Project project, @NotNull DebuggableFileFinder fileFinder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/update/CssHelper", "sourceEquals"));
        }
        if (remoteUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteUrl", "com/jetbrains/liveEdit/update/CssHelper", "sourceEquals"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/update/CssHelper", "sourceEquals"));
        }
        if (fileFinder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileFinder", "com/jetbrains/liveEdit/update/CssHelper", "sourceEquals"));
        }
        return file.equals(fileFinder.findFile(remoteUrl, project)) || Urls.equalsIgnoreParameters((Url)remoteUrl, (Collection)fileFinder.getRemoteUrls(file), (boolean)SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    private static SourceRange getSourceRange(@NotNull Document document, @NotNull PsiElement element) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/liveEdit/update/CssHelper", "getSourceRange"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/liveEdit/update/CssHelper", "getSourceRange"));
        }
        int start = element.getNode().getStartOffset();
        int end = start + element.getNode().getTextLength();
        int startLine = document.getLineNumber(start);
        int startColumn = start - document.getLineStartOffset(startLine);
        int endLine = document.getLineNumber(end);
        int endColumn = end - document.getLineStartOffset(endLine);
        SourceRange sourceRange = new SourceRange(startLine, startColumn, endLine, endColumn + 1);
        if (sourceRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/update/CssHelper", "getSourceRange"));
        }
        return sourceRange;
    }

    private static boolean compareSelectorList(@Nullable CssSelectorList local, @Nullable CssSelectorList remote) {
        CssSelector[] remoteSelectors;
        if (local == null || remote == null) {
            return false;
        }
        CssSelector[] localSelectors = local.getSelectors();
        if (localSelectors.length != (remoteSelectors = remote.getSelectors()).length) {
            return false;
        }
        int n = remoteSelectors.length;
        for (int i = 0; i < n; ++i) {
            PsiElement[] remoteSelectorElements;
            CssSelector localSelector = localSelectors[i];
            CssSelector remoteSelector = remoteSelectors[i];
            if (localSelector.getSpecificity().compareTo((Object)remoteSelector.getSpecificity()) != 0) {
                return false;
            }
            PsiElement[] localSelectorElements = localSelector.getElements();
            if (localSelectorElements.length != (remoteSelectorElements = remoteSelector.getElements()).length) {
                return false;
            }
            for (int j = 0; j < localSelectorElements.length; ++j) {
                PsiElement localElement = localSelectorElements[j];
                if (localElement instanceof CssSimpleSelector && remoteSelectorElements[j] instanceof CssSimpleSelector) {
                    CssSimpleSelector localSelectorElement = (CssSimpleSelector)localElement;
                    CssSimpleSelector remoteSelectorElement = (CssSimpleSelector)localElement;
                    if (localSelectorElement.isUniversalSelector() == remoteSelectorElement.isUniversalSelector()) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static Processor<RemoteCssStyleSheet> createSetCssPropertyProcessor(final @NotNull CssDeclaration localDeclaration, final @Nullable CharSequence value) {
        if (localDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localDeclaration", "com/jetbrains/liveEdit/update/CssHelper", "createSetCssPropertyProcessor"));
        }
        Processor<RemoteCssStyleSheet> processor = new Processor<RemoteCssStyleSheet>(){

            public boolean process(final RemoteCssStyleSheet styleSheet) {
                styleSheet.getFile().doWhenDone((Consumer)new Consumer<StylesheetFile>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void consume(@NotNull StylesheetFile remoteFile) {
                        String newIdeaValue;
                        WipRequest message;
                        CssDeclaration remoteDeclaration;
                        if (remoteFile == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteFile", "com/jetbrains/liveEdit/update/CssHelper$2$1", "consume"));
                        }
                        String styleSheetId = styleSheet.descriptor.styleSheetId();
                        AccessToken token = ReadAction.start();
                        try {
                            if (!localDeclaration.isValid()) {
                                return;
                            }
                            CssRuleset cssRuleset = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)localDeclaration, CssRuleset.class);
                            CssStylesheet cssStyleSheet = (CssStylesheet)PsiTreeUtil.getParentOfType((PsiElement)cssRuleset, CssStylesheet.class);
                            if (cssStyleSheet == null) {
                                return;
                            }
                            int sourceRulesetIndex = ArrayUtil.indexOf((Object[])cssStyleSheet.getRulesets(true), (Object)cssRuleset);
                            CssStylesheet remoteCssStylesheet = remoteFile.getStylesheet();
                            assert (remoteCssStylesheet != null);
                            CssRuleset[] remoteCssRulesets = remoteCssStylesheet.getRulesets(true);
                            if (sourceRulesetIndex >= remoteCssRulesets.length) {
                                return;
                            }
                            CssRuleset remoteRuleset = remoteCssRulesets[sourceRulesetIndex];
                            if (!CssHelper.compareSelectorList(cssRuleset.getSelectorList(), remoteRuleset.getSelectorList())) {
                                return;
                            }
                            String text = localDeclaration.getPropertyName() + ':' + (value == null ? "" : value) + ';';
                            Document document = styleSheet.document;
                            assert (document != null);
                            CssBlock remoteCssBlock = remoteRuleset.getBlock();
                            CssDeclaration cssDeclaration = remoteDeclaration = remoteCssBlock == null ? null : remoteCssBlock.findDeclaration(localDeclaration.getPropertyName(), false);
                            if (remoteDeclaration == null) {
                                if (remoteCssBlock == null) {
                                    return;
                                }
                                int start = remoteCssBlock.getNode().getStartOffset();
                                int end = start + remoteCssBlock.getNode().getTextLength() - 1;
                                int endLine = document.getLineNumber(end);
                                int endColumn = end - document.getLineStartOffset(endLine);
                                StyleDeclarationEdit styleDeclarationEdit = new StyleDeclarationEdit((CharSequence)styleSheetId, new SourceRange(endLine, endColumn, endLine, endColumn), (CharSequence)text);
                                message = CSSKt.SetStyleTexts(Collections.singletonList(styleDeclarationEdit));
                            } else {
                                StyleDeclarationEdit styleDeclarationEdit = new StyleDeclarationEdit((CharSequence)styleSheetId, CssHelper.getSourceRange(document, (PsiElement)remoteDeclaration), (CharSequence)text);
                                message = CSSKt.SetStyleTexts(Collections.singletonList(styleDeclarationEdit));
                            }
                            CssTermList cssDeclarationValue = localDeclaration.getValue();
                            newIdeaValue = cssDeclarationValue == null ? null : cssDeclarationValue.getText();
                        }
                        finally {
                            token.finish();
                        }
                        this.doSendMessage((Request<SetStyleTextsResult>)((Request)message), newIdeaValue, remoteDeclaration, styleSheet);
                    }
                }).doWhenRejected(error -> ApplicationInspectorImplKt.getLOG().error("Cannot get PSI CSS file: " + (String)ObjectUtils.notNull((Object)error, (Object)"internal error")));
                return false;
            }

            private void doSendMessage(@NotNull Request<SetStyleTextsResult> message, @Nullable String newIdeaValue, @Nullable CssDeclaration remoteDeclaration, @NotNull RemoteCssStyleSheet styleSheet) {
                if (message == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/liveEdit/update/CssHelper$2", "doSendMessage"));
                }
                if (styleSheet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleSheet", "com/jetbrains/liveEdit/update/CssHelper$2", "doSendMessage"));
                }
                styleSheet.stopUpdates();
                styleSheet.commandProcessor.send(message).done(o -> {
                    if (styleSheet == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleSheet", "com/jetbrains/liveEdit/update/CssHelper$2", "lambda$doSendMessage$2"));
                    }
                    if (RemoteCssStyleSheet.isNeedToGetTextAfterChange() || newIdeaValue == null || remoteDeclaration == null || !remoteDeclaration.isValid()) {
                        styleSheet.startUpdates(false);
                    } else {
                        styleSheet.addIncrementalUpdate(() -> remoteDeclaration.setValue(newIdeaValue));
                    }
                }).rejected(throwable -> {
                    if (styleSheet == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleSheet", "com/jetbrains/liveEdit/update/CssHelper$2", "lambda$doSendMessage$3"));
                    }
                    styleSheet.startUpdates(false);
                });
            }
        };
        if (processor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/update/CssHelper", "createSetCssPropertyProcessor"));
        }
        return processor;
    }

    @NotNull
    public static List<VirtualFile> collectEffective(@NotNull List<RemoteCssStyleSheet> list, @NotNull Collection<VirtualFile> files, @NotNull Project project, @NotNull DebuggableFileFinder fileFinder) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/liveEdit/update/CssHelper", "collectEffective"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/liveEdit/update/CssHelper", "collectEffective"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/update/CssHelper", "collectEffective"));
        }
        if (fileFinder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileFinder", "com/jetbrains/liveEdit/update/CssHelper", "collectEffective"));
        }
        List effectiveFiles = null;
        block0: for (VirtualFile file : files) {
            for (RemoteCssStyleSheet styleSheet : list) {
                if (!CssHelper.sourceEquals(file, styleSheet.url, project, fileFinder)) continue;
                if (effectiveFiles == null) {
                    effectiveFiles = new SmartList();
                }
                effectiveFiles.add(file);
                continue block0;
            }
        }
        List<Object> list2 = effectiveFiles == null ? Collections.emptyList() : effectiveFiles;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/update/CssHelper", "collectEffective"));
        }
        return list2;
    }

    public static void processStylesheets(@NotNull List<RemoteCssStyleSheet> list, @NotNull VirtualFile file, @NotNull DebuggableFileFinder fileFinder, @NotNull Processor<RemoteCssStyleSheet> processor) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/liveEdit/update/CssHelper", "processStylesheets"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/update/CssHelper", "processStylesheets"));
        }
        if (fileFinder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileFinder", "com/jetbrains/liveEdit/update/CssHelper", "processStylesheets"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/liveEdit/update/CssHelper", "processStylesheets"));
        }
        for (RemoteCssStyleSheet styleSheet : list) {
            if (!CssHelper.sourceEquals(file, styleSheet.url, styleSheet.project, fileFinder) || !processor.process((Object)styleSheet)) continue;
            break;
        }
    }
}

