/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.update;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.jetbrains.liveEdit.update.FileScriptProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;

public final class EffectiveFileScriptProcessor
extends FileScriptProcessor {
    private List<VirtualFile> effectiveFiles;
    private List<VirtualFile> transformedFiles;

    private EffectiveFileScriptProcessor(@NotNull JavaScriptDebugProcess<? extends VmConnection> debugProcess) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/liveEdit/update/EffectiveFileScriptProcessor", "<init>"));
        }
        super(debugProcess);
    }

    @NotNull
    public static List<VirtualFile> getEffectiveFiles(@NotNull Collection<VirtualFile> files, @NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull Vm vm) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/liveEdit/update/EffectiveFileScriptProcessor", "getEffectiveFiles"));
        }
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/liveEdit/update/EffectiveFileScriptProcessor", "getEffectiveFiles"));
        }
        if (vm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vm", "com/jetbrains/liveEdit/update/EffectiveFileScriptProcessor", "getEffectiveFiles"));
        }
        List<VirtualFile> list = EffectiveFileScriptProcessor.getEffective(files, debugProcess, vm).getEffectiveFiles();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/update/EffectiveFileScriptProcessor", "getEffectiveFiles"));
        }
        return list;
    }

    @NotNull
    public static EffectiveFileScriptProcessor getEffective(@NotNull Collection<VirtualFile> files, @NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull Vm vm) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/liveEdit/update/EffectiveFileScriptProcessor", "getEffective"));
        }
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/liveEdit/update/EffectiveFileScriptProcessor", "getEffective"));
        }
        if (vm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vm", "com/jetbrains/liveEdit/update/EffectiveFileScriptProcessor", "getEffective"));
        }
        EffectiveFileScriptProcessor processor = new EffectiveFileScriptProcessor(debugProcess);
        for (VirtualFile file : files) {
            processor.reset(file);
            vm.getScriptManager().forEachScript((Processor)processor);
        }
        EffectiveFileScriptProcessor effectiveFileScriptProcessor = processor;
        if (effectiveFileScriptProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/update/EffectiveFileScriptProcessor", "getEffective"));
        }
        return effectiveFileScriptProcessor;
    }

    public boolean process(Script script) {
        if (this.isScriptFile(script.getUrl())) {
            if (this.effectiveFiles == null) {
                this.effectiveFiles = new SmartList();
            }
            this.effectiveFiles.add(this.file);
            return false;
        }
        if (this.isSourceFile(script)) {
            if (this.transformedFiles == null) {
                this.transformedFiles = new SmartList();
            }
            this.transformedFiles.add(this.file);
        }
        return true;
    }

    @NotNull
    public List<VirtualFile> getEffectiveFiles() {
        List<Object> list = this.effectiveFiles == null ? Collections.emptyList() : this.effectiveFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/update/EffectiveFileScriptProcessor", "getEffectiveFiles"));
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> getTransformedFiles() {
        List<Object> list = this.transformedFiles == null ? Collections.emptyList() : this.transformedFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/update/EffectiveFileScriptProcessor", "getTransformedFiles"));
        }
        return list;
    }
}

