/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.update;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.sourcemap.SourceMap;

public abstract class FileScriptProcessor
implements Processor<Script> {
    public final JavaScriptDebugProcess<? extends VmConnection> debugProcess;
    protected VirtualFile file;
    private List<Url> fileUrls;

    public FileScriptProcessor(@NotNull JavaScriptDebugProcess<? extends VmConnection> debugProcess) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/liveEdit/update/FileScriptProcessor", "<init>"));
        }
        this.debugProcess = debugProcess;
    }

    public final void reset(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/update/FileScriptProcessor", "reset"));
        }
        this.file = file;
        this.fileUrls = null;
    }

    protected final boolean isScriptFile(@NotNull Url url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/liveEdit/update/FileScriptProcessor", "isScriptFile"));
        }
        return this.file.equals(this.debugProcess.findFile(url)) || this.checkUrl(url);
    }

    protected final boolean isSourceFile(@NotNull Script script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/jetbrains/liveEdit/update/FileScriptProcessor", "isSourceFile"));
        }
        SourceMap sourceMap = script.getSourceMap();
        if (sourceMap != null) {
            for (Url url : sourceMap.getSources()) {
                if (!this.isScriptFile(url)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkUrl(@NotNull Url url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/liveEdit/update/FileScriptProcessor", "checkUrl"));
        }
        if (this.fileUrls == null) {
            this.fileUrls = this.debugProcess.getFinder().getRemoteUrls(this.file);
        }
        return Urls.equalsIgnoreParameters((Url)url, this.fileUrls, (boolean)SystemInfoRt.isFileSystemCaseSensitive);
    }
}

