/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.update;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.AsyncValueLoaderManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Url;
import com.jetbrains.liveEdit.ApplicationInspectorImplKt;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.protocol.css.CSSKt;
import org.jetbrains.wip.protocol.css.CSSStyleSheetHeaderValue;

public final class RemoteCssStyleSheet {
    private static final boolean NEED_TO_GET_TEXT_AFTER_CHANGE = true;
    private static final AsyncValueLoaderManager<RemoteCssStyleSheet, StylesheetFile> FILE_LOADER = new AsyncValueLoaderManager<RemoteCssStyleSheet, StylesheetFile>(RemoteCssStyleSheet.class){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load(@NotNull RemoteCssStyleSheet styleSheet, @NotNull AsyncResult<StylesheetFile> mainResult) {
            StylesheetFile psiFile;
            List updates;
            if (styleSheet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleSheet", "com/jetbrains/liveEdit/update/RemoteCssStyleSheet$1", "load"));
            }
            if (mainResult == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainResult", "com/jetbrains/liveEdit/update/RemoteCssStyleSheet$1", "load"));
            }
            List list = styleSheet.pendingUpdates;
            synchronized (list) {
                updates = styleSheet.pendingUpdates;
                if (!updates.isEmpty()) {
                    styleSheet.pendingUpdates.clear();
                }
            }
            if (!updates.isEmpty() && (psiFile = styleSheet.psiFile).isValid()) {
                Runnable runnable = () -> {
                    if (mainResult == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainResult", "com/jetbrains/liveEdit/update/RemoteCssStyleSheet$1", "lambda$load$0"));
                    }
                    try {
                        for (Runnable update : updates) {
                            update.run();
                        }
                    }
                    catch (Exception e) {
                        mainResult.reject(e.getMessage());
                        return;
                    }
                    mainResult.setDone((Object)psiFile);
                };
                Application application = ApplicationManager.getApplication();
                if (application.isDispatchThread()) {
                    application.runWriteAction(runnable);
                } else {
                    application.invokeLater(() -> ApplicationManager.getApplication().runWriteAction(runnable), ModalityState.any());
                }
                return;
            }
            styleSheet.commandProcessor.send((Request)CSSKt.GetStyleSheetText((CharSequence)styleSheet.descriptor.styleSheetId())).done(result -> {
                if (styleSheet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleSheet", "com/jetbrains/liveEdit/update/RemoteCssStyleSheet$1", "lambda$load$2"));
                }
                if (mainResult == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainResult", "com/jetbrains/liveEdit/update/RemoteCssStyleSheet$1", "lambda$load$2"));
                }
                styleSheet.contentLoaded(result.text(), (AsyncResult<StylesheetFile>)mainResult);
            }).rejected(error -> {
                if (mainResult == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainResult", "com/jetbrains/liveEdit/update/RemoteCssStyleSheet$1", "lambda$load$3"));
                }
                mainResult.reject(error.getMessage());
            });
        }
    };
    public volatile Document document;
    private volatile LightVirtualFile virtualFile;
    private volatile StylesheetFile psiFile;
    public final Project project;
    public final WipCommandProcessor commandProcessor;
    public final CSSStyleSheetHeaderValue descriptor;
    public final Url url;
    private volatile AsyncResult<StylesheetFile> file;
    private boolean updatesStopped;
    private int changedCount;
    private final List<Runnable> pendingUpdates;

    public RemoteCssStyleSheet(@NotNull CSSStyleSheetHeaderValue descriptor, @NotNull Url url, @NotNull WipCommandProcessor commandProcessor, @NotNull Project project) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/liveEdit/update/RemoteCssStyleSheet", "<init>"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/liveEdit/update/RemoteCssStyleSheet", "<init>"));
        }
        if (commandProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandProcessor", "com/jetbrains/liveEdit/update/RemoteCssStyleSheet", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/update/RemoteCssStyleSheet", "<init>"));
        }
        this.pendingUpdates = new ArrayList<Runnable>();
        this.descriptor = descriptor;
        this.url = url;
        this.commandProcessor = commandProcessor;
        this.project = project;
    }

    public static boolean isNeedToGetTextAfterChange() {
        return true;
    }

    @NotNull
    public AsyncResult<StylesheetFile> getFile() {
        AsyncResult asyncResult = FILE_LOADER.get((Object)this);
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/update/RemoteCssStyleSheet", "getFile"));
        }
        return asyncResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void contentLoaded(@NotNull String text, @NotNull AsyncResult<StylesheetFile> mainResult) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/liveEdit/update/RemoteCssStyleSheet", "contentLoaded"));
        }
        if (mainResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainResult", "com/jetbrains/liveEdit/update/RemoteCssStyleSheet", "contentLoaded"));
        }
        LightVirtualFile virtualFile = this.virtualFile;
        if (virtualFile == null) {
            PsiFile psiFile;
            Document document;
            virtualFile = new LightVirtualFile(this.url.trimParameters().toDecodedForm(), (FileType)CssFileType.INSTANCE, (CharSequence)text);
            this.document = document = ((EditorFactoryImpl)EditorFactory.getInstance()).createDocument((CharSequence)text, true, true);
            this.virtualFile = virtualFile;
            UndoConstants.DONT_RECORD_UNDO.set((UserDataHolder)document, (Object)Boolean.TRUE);
            UndoConstants.DONT_RECORD_UNDO.set((UserDataHolder)virtualFile, (Object)Boolean.TRUE);
            FileDocumentManagerImpl.registerDocument((Document)document, (VirtualFile)virtualFile);
            PsiManager psiManager = PsiManager.getInstance((Project)this.project);
            AccessToken token = ReadAction.start();
            try {
                psiFile = psiManager.findFile((VirtualFile)virtualFile);
            }
            finally {
                token.finish();
            }
            if (psiFile instanceof StylesheetFile) {
                this.psiFile = (StylesheetFile)psiFile;
                mainResult.setDone((Object)((StylesheetFile)psiFile));
            } else {
                String message = "cannot create css psi file from stylesheet " + virtualFile.getPath();
                ApplicationInspectorImplKt.getLOG().warn(message);
                mainResult.reject(message);
            }
        } else {
            virtualFile.setContent(null, (CharSequence)text, false);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (mainResult == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainResult", "com/jetbrains/liveEdit/update/RemoteCssStyleSheet", "lambda$contentLoaded$2"));
                }
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/liveEdit/update/RemoteCssStyleSheet", "lambda$contentLoaded$2"));
                }
                if (this.project.isDisposed()) {
                    mainResult.reject("project disposed");
                    return;
                }
                WriteAction.run(() -> {
                    if (text == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/liveEdit/update/RemoteCssStyleSheet", "lambda$null$1"));
                    }
                    DocumentUtil.writeInRunUndoTransparentAction(() -> {
                        if (text == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/liveEdit/update/RemoteCssStyleSheet", "lambda$null$0"));
                        }
                        this.document.setText((CharSequence)text);
                    });
                    PsiDocumentManager.getInstance((Project)this.project).commitDocument(this.document);
                });
                mainResult.setDone((Object)this.psiFile);
            }, ModalityState.any());
        }
    }

    public synchronized void onChanged() {
        if (this.updatesStopped) {
            ++this.changedCount;
        } else {
            FILE_LOADER.reset((Object)this);
        }
    }

    public synchronized void stopUpdates() {
        this.updatesStopped = true;
    }

    public synchronized void startUpdates(boolean ignoreUpdate) {
        this.updatesStopped = false;
        if (ignoreUpdate) {
            --this.changedCount;
        }
        if (this.changedCount > 0) {
            this.changedCount = 0;
            FILE_LOADER.reset((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncrementalUpdate(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/jetbrains/liveEdit/update/RemoteCssStyleSheet", "addIncrementalUpdate"));
        }
        List<Runnable> list = this.pendingUpdates;
        synchronized (list) {
            this.pendingUpdates.add(runnable);
        }
        this.startUpdates(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIncrementalUpdates() {
        List<Runnable> list = this.pendingUpdates;
        synchronized (list) {
            this.pendingUpdates.clear();
        }
    }
}

