/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.update;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebugProcess;
import com.jetbrains.liveEdit.LiveEditOptions;
import com.jetbrains.liveEdit.update.ApplicationUpdaterKt;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

final class RestartRequiredNotificationItem
extends NotificationListener.Adapter
implements Runnable {
    private final XDebugProcess debugProcess;
    private final List<Notification> notifications;

    public RestartRequiredNotificationItem(@NotNull XDebugProcess debugProcess) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/liveEdit/update/RestartRequiredNotificationItem", "<init>"));
        }
        this.notifications = new SmartList();
        this.debugProcess = debugProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActiveNotification() {
        Balloon currentBalloon = ToolWindowManager.getInstance((Project)this.debugProcess.getSession().getProject()).getToolWindowBalloon(ApplicationUpdaterKt.getNOTIFICATION_GROUP().getToolWindowId());
        if (currentBalloon != null) {
            List<Notification> list = this.notifications;
            synchronized (list) {
                if (!this.notifications.isEmpty()) {
                    for (int i = this.notifications.size() - 1; i >= 0; --i) {
                        Notification notification = this.notifications.get(i);
                        if (notification == null) continue;
                        if (notification.isExpired()) break;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/liveEdit/update/RestartRequiredNotificationItem", "notify"));
        }
        Notification notification = ApplicationUpdaterKt.warn(message, this.debugProcess, (NotificationListener)this);
        List<Notification> list = this.notifications;
        synchronized (list) {
            this.notifications.add(notification);
        }
        notification.whenExpired((Runnable)this);
    }

    protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/jetbrains/liveEdit/update/RestartRequiredNotificationItem", "hyperlinkActivated"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/liveEdit/update/RestartRequiredNotificationItem", "hyperlinkActivated"));
        }
        notification.expire();
        String description = e.getDescription();
        if (!description.equals("restart")) {
            LiveEditOptions.getInstance().setRestartIfHotSwapFailed(true);
        }
        ApplicationUpdaterKt.restart(this.debugProcess);
    }

    public void clear() {
        for (Notification notification : this.notifications) {
            if (notification == null || notification.isExpired()) continue;
            notification.whenExpired(null);
            notification.expire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<Notification> list = this.notifications;
        synchronized (list) {
            int size = this.notifications.size();
            for (int i = 0; i < size; ++i) {
                Notification notification = this.notifications.get(i);
                if (notification == null || !notification.isExpired()) continue;
                this.notifications.set(i, null);
            }
        }
    }
}

