/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.update;

import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.AppUIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.liveEdit.LiveEditOptions;
import com.jetbrains.liveEdit.UpdatePolicy;
import org.jetbrains.annotations.NotNull;

public class UpdateConfiguration {
    protected UpdateConfiguration() {
    }

    @NotNull
    public UpdatePolicy getPolicy() {
        UpdatePolicy updatePolicy = LiveEditOptions.getInstance().getUpdatePolicy();
        if (updatePolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/update/UpdateConfiguration", "getPolicy"));
        }
        return updatePolicy;
    }

    @NotNull
    public CharSequence preprocessSource(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/liveEdit/update/UpdateConfiguration", "preprocessSource"));
        }
        CharSequence charSequence = text;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/update/UpdateConfiguration", "preprocessSource"));
        }
        return charSequence;
    }

    public void restart(@NotNull XDebugProcess debugProcess) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/liveEdit/update/UpdateConfiguration", "restart"));
        }
        AppUIUtil.invokeOnEdt(() -> {
            if (debugProcess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/jetbrains/liveEdit/update/UpdateConfiguration", "lambda$restart$0"));
            }
            XDebugSession session = debugProcess.getSession();
            RunContentDescriptor descriptor = session.getRunContentDescriptor();
            descriptor.setActivateToolWindowWhenAdded(false);
            descriptor.setReuseToolWindowActivation(true);
            ExecutionUtil.restart((RunContentDescriptor)descriptor);
        }, (Condition)debugProcess.getSession().getProject().getDisposed());
    }
}

