/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.valueAdjuster;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.jetbrains.liveEdit.valueAdjuster.Mapper;
import com.jetbrains.liveEdit.valueAdjuster.ValueAdjusterFactory;

public abstract class AbstractAdjuster<T>
extends ValueAdjusterFactory.ValueAdjuster {
    private final RangeMarker myMarker;
    private int myLastSliderValue;
    private final Mapper<T> myMapper;

    public AbstractAdjuster(PsiElement element) {
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(element.getContainingFile());
        assert (document != null);
        this.myMarker = document.createRangeMarker(element.getTextRange());
        this.myMapper = this.createMapper(this.getCurrentRealValue());
        this.myLastSliderValue = this.getCurrentSliderValue();
    }

    @Override
    void setValue(Editor editor, int newValue) {
        if (newValue == this.myLastSliderValue) {
            return;
        }
        this.doSetValue(editor, this.myMapper.getRealValue(newValue));
        this.myLastSliderValue = newValue;
    }

    @Override
    public void dispose() {
    }

    private void doSetValue(Editor editor, T newValue) {
        CommandProcessor.getInstance().executeCommand(editor.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
            this.myMarker.getDocument().replaceString(this.myMarker.getStartOffset(), this.myMarker.getEndOffset(), (CharSequence)this.valueToString(newValue));
            this.sync(newValue);
        }), "Adjust Value", null, editor.getDocument());
    }

    protected abstract T valueFromString(String var1);

    protected abstract String valueToString(T var1);

    protected abstract void sync(T var1);

    protected abstract Mapper<T> createMapper(T var1);

    @Override
    public int getMaximum() {
        return 100;
    }

    @Override
    public int getMinimum() {
        return 0;
    }

    private T getCurrentRealValue() {
        CharSequence s = this.myMarker.getDocument().getCharsSequence().subSequence(this.myMarker.getStartOffset(), this.myMarker.getEndOffset());
        return this.valueFromString(s.toString());
    }

    @Override
    public int getCurrentSliderValue() {
        T realValue = this.getCurrentRealValue();
        return this.myMapper.getSliderValue(realValue);
    }
}

