/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.valueAdjuster;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.liveEdit.PsiSynchronizer;
import com.jetbrains.liveEdit.valueAdjuster.AbstractAdjuster;
import com.jetbrains.liveEdit.valueAdjuster.Mapper;
import com.jetbrains.liveEdit.valueAdjuster.ValueAdjusterFactory;
import org.jetbrains.annotations.Nullable;

class JsNumberAdjusterFactory
extends ValueAdjusterFactory {
    JsNumberAdjusterFactory() {
    }

    @Nullable
    private static PsiElement getNumberElement(PsiElement elementAtCaret) {
        if (elementAtCaret.getNode().getElementType() == JSTokenTypes.NUMERIC_LITERAL) {
            return elementAtCaret;
        }
        return null;
    }

    @Override
    @Nullable
    public ValueAdjusterFactory.ValueAdjuster createAdjuster(PsiElement elementAtCaret) {
        PsiElement element = JsNumberAdjusterFactory.getNumberElement(elementAtCaret);
        if (element == null) {
            return null;
        }
        final PsiFile file = elementAtCaret.getContainingFile();
        if (file == null) {
            return null;
        }
        final PsiSynchronizer synchronizer = PsiSynchronizer.get(file.getFileType());
        if (synchronizer == null) {
            return null;
        }
        return new AbstractAdjuster<Integer>(element){

            @Override
            protected Integer valueFromString(String s) {
                try {
                    return Integer.parseInt(s);
                }
                catch (NumberFormatException ignored) {
                    return 1;
                }
            }

            @Override
            protected String valueToString(Integer value) {
                return String.valueOf(value);
            }

            @Override
            protected void sync(Integer value) {
                Runnable runnable;
                if (synchronizer.schedule(3, (PsiElement)file, (PsiElement)file, file) && (runnable = synchronizer.flushSyncTask()) != null) {
                    runnable.run();
                }
            }

            @Override
            protected Mapper<Integer> createMapper(Integer currentValue) {
                return new Mapper.LinearNumberMapper(0, 100);
            }
        };
    }
}

