/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.webDeployment;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.liveEdit.Deployer;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import org.jetbrains.annotations.NotNull;

class WebDeployer
extends Deployer {
    WebDeployer() {
    }

    @Override
    @NotNull
    public AsyncResult<Void> deploy(@NotNull PsiFile file, boolean triggeredByExplicitAction) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/webDeployment/WebDeployer", "deploy"));
        }
        AsyncResult<Void> asyncResult = this.deploy(file.getViewProvider().getVirtualFile(), file.getProject(), triggeredByExplicitAction);
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/webDeployment/WebDeployer", "deploy"));
        }
        return asyncResult;
    }

    @Override
    @NotNull
    public AsyncResult<Void> deploy(@NotNull VirtualFile file, @NotNull Project project, boolean triggeredByExplicitAction) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/liveEdit/webDeployment/WebDeployer", "deploy"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/liveEdit/webDeployment/WebDeployer", "deploy"));
        }
        PublishConfig.AutoUploadState state = PublishConfig.getInstance((Project)project).getAutoUploadState();
        if (state == PublishConfig.AutoUploadState.NEVER || !triggeredByExplicitAction && state != PublishConfig.AutoUploadState.ALWAYS || !PublishActionUtil.canUploadToDefaultServer((Project)project, (VirtualFile)file)) {
            AsyncResult asyncResult = AsyncResult.done(null);
            if (asyncResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/webDeployment/WebDeployer", "deploy"));
            }
            return asyncResult;
        }
        AsyncResult asyncResult = PublishActionUtil.uploadToDefaultServer((Project)project, (VirtualFile[])new VirtualFile[]{file});
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/liveEdit/webDeployment/WebDeployer", "deploy"));
        }
        return asyncResult;
    }
}

