/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus.structureView;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.impl.structure.CssStructureViewElement;
import com.intellij.psi.css.impl.structure.CssStructureViewElementsProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.stylus.StylusLanguage;
import org.jetbrains.plugins.stylus.psi.StylusCssBlock;
import org.jetbrains.plugins.stylus.psi.StylusVariableDeclaration;
import org.jetbrains.plugins.stylus.psi.impl.StylusMixinImpl;
import org.jetbrains.plugins.stylus.structureView.StylusVariableStructureViewElement;
import org.jetbrains.plugins.stylus.structureView.StylusVariablesFilter;

public class StylusStructureViewElementsProvider
extends CssStructureViewElementsProvider {
    private static final Filter[] STYLUS_FILTERS = new Filter[]{new StylusVariablesFilter()};
    private static final Class[] STYLUS_SUITABLE_CLASSES = new Class[]{StylusMixinImpl.class, StylusVariableDeclaration.class, StylusCssBlock.class};

    @NotNull
    public Collection<? extends CssStructureViewElement> createStructureViewElements(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/stylus/structureView/StylusStructureViewElementsProvider", "createStructureViewElements"));
        }
        if (element.getLanguage() != StylusLanguage.INSTANCE || this.shouldSkipElement(element)) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/structureView/StylusStructureViewElementsProvider", "createStructureViewElements"));
            }
            return list;
        }
        if (element instanceof StylusMixinImpl) {
            List<CssStructureViewElement> list = Collections.singletonList(CssStructureViewElement.create((PsiElement)element));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/structureView/StylusStructureViewElementsProvider", "createStructureViewElements"));
            }
            return list;
        }
        if (element instanceof StylusCssBlock) {
            List<CssStructureViewElement> list = Collections.singletonList(CssStructureViewElement.create((PsiElement)element, null, (String)((StylusCssBlock)element).getName()));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/structureView/StylusStructureViewElementsProvider", "createStructureViewElements"));
            }
            return list;
        }
        if (element instanceof StylusVariableDeclaration) {
            List<StylusVariableStructureViewElement> list = Collections.singletonList(new StylusVariableStructureViewElement((StylusVariableDeclaration)element));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/structureView/StylusStructureViewElementsProvider", "createStructureViewElements"));
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/structureView/StylusStructureViewElementsProvider", "createStructureViewElements"));
        }
        return list;
    }

    public boolean isMyContext(PsiElement element) {
        return StylusLanguage.INSTANCE.is(CssPsiUtil.getStylesheetLanguage((PsiElement)element));
    }

    @NotNull
    public Filter[] getFilters() {
        if (STYLUS_FILTERS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/structureView/StylusStructureViewElementsProvider", "getFilters"));
        }
        return STYLUS_FILTERS;
    }

    @NotNull
    public Class[] getSuitableClasses() {
        if (STYLUS_SUITABLE_CLASSES == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/structureView/StylusStructureViewElementsProvider", "getSuitableClasses"));
        }
        return STYLUS_SUITABLE_CLASSES;
    }

    public boolean hasInnerStructure(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/stylus/structureView/StylusStructureViewElementsProvider", "hasInnerStructure"));
        }
        return element instanceof StylusCssBlock;
    }

    public boolean shouldSkipElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/stylus/structureView/StylusStructureViewElementsProvider", "shouldSkipElement"));
        }
        return element instanceof StylusVariableDeclaration && element.getParent() instanceof StylusMixinImpl;
    }
}

