/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css;

import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.lexing.CssLexer;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class CssNamesValidator
implements NamesValidator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.css.CssNamesValidator");
    private Lexer myLexer;

    private IElementType getLexerType(String text) {
        if (this.myLexer == null) {
            this.myLexer = new CssLexer();
        }
        this.myLexer.start((CharSequence)text);
        return this.myLexer.getTokenEnd() == text.length() ? this.myLexer.getTokenType() : null;
    }

    public synchronized boolean isKeyword(@NotNull String name, Project project) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/css/CssNamesValidator", "isKeyword"));
        }
        try {
            return this.getLexerType(name) == CssElementTypes.CSS_KEYWORD;
        }
        catch (Exception e) {
            LOG.error(String.format("Value: '%s'", name), (Throwable)e);
            return false;
        }
    }

    public synchronized boolean isIdentifier(@NotNull String name, Project project) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/css/CssNamesValidator", "isIdentifier"));
        }
        return this.getLexerType(name) == CssElementTypes.CSS_IDENT;
    }
}

