/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.settings;

import com.intellij.lang.PerFileMappings;
import com.intellij.lang.css.CssDialect;
import com.intellij.lang.css.CssDialectMappings;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.tree.PerFileConfigurableBase;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssDialectsConfigurable
extends PerFileConfigurableBase<CssDialect> {
    static final String ID = "settings.css.dialects";

    public CssDialectsConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/css/settings/CssDialectsConfigurable", "<init>"));
        }
        super(project, (PerFileMappings)CssDialectMappings.getInstance(project));
    }

    @Nls
    public String getDisplayName() {
        return CssBundle.message((String)"css.dialects.title", (Object[])new Object[0]);
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/settings/CssDialectsConfigurable", "getId"));
        }
        return ID;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    protected <S> Object getParameter(@NotNull Key<S> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/css/settings/CssDialectsConfigurable", "getParameter"));
        }
        if (key == DESCRIPTION) {
            return CssBundle.message((String)"css.dialects.caption", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()});
        }
        if (key == MAPPING_TITLE) {
            return CssBundle.message((String)"css.dialects.column.title", (Object[])new Object[0]);
        }
        if (key == OVERRIDE_QUESTION) {
            return CssBundle.message((String)"css.dialects.override.warning.text", (Object[])new Object[0]);
        }
        if (key == OVERRIDE_TITLE) {
            return CssBundle.message((String)"css.dialects.override.warning.title", (Object[])new Object[0]);
        }
        return null;
    }

    protected void renderValue(@Nullable Object target, @NotNull CssDialect dialect, @NotNull ColoredTextContainer renderer) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/lang/css/settings/CssDialectsConfigurable", "renderValue"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/lang/css/settings/CssDialectsConfigurable", "renderValue"));
        }
        renderer.append(dialect.getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    protected void renderDefaultValue(Object target, @NotNull ColoredTextContainer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/lang/css/settings/CssDialectsConfigurable", "renderDefaultValue"));
        }
        CssDialect t = (CssDialect)this.getNewMapping((VirtualFile)target);
        if (t == null) {
            return;
        }
        renderer.append(t.getDisplayName(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
    }
}

