/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation;

import com.intellij.navigation.RelatedToHtmlFilesContributor;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.resolve.CssElementProcessor;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.impl.XhtmlFileInfo;
import com.intellij.psi.xml.XmlFile;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CssRelatedToHtmlFilesContributor
extends RelatedToHtmlFilesContributor {
    public void fillRelatedFiles(@NotNull XmlFile xmlFile, final @NotNull Set<PsiFile> resultSet) {
        PsiElement[] links;
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/navigation/CssRelatedToHtmlFilesContributor", "fillRelatedFiles"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/navigation/CssRelatedToHtmlFilesContributor", "fillRelatedFiles"));
        }
        for (PsiElement link : links = XhtmlFileInfo.gatherLinks(xmlFile, true)) {
            if (link instanceof PsiFile) {
                resultSet.add((PsiFile)link);
                continue;
            }
            Collections.addAll(resultSet, CssResolveManager.getInstance().resolveFiles(link, (PsiFile)xmlFile));
        }
        CssResolveManager.getInstance().getNewResolver().processOneFile(xmlFile, new CssElementProcessor(){

            public boolean process(@NotNull CssStylesheet stylesheet) {
                if (stylesheet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stylesheet", "com/intellij/navigation/CssRelatedToHtmlFilesContributor$1", "process"));
                }
                CssRelatedToHtmlFilesContributor.processImports(stylesheet, resultSet);
                return true;
            }
        }, false);
    }

    static void processImports(@NotNull CssStylesheet stylesheet, @NotNull Set<PsiFile> resultSet) {
        if (stylesheet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stylesheet", "com/intellij/navigation/CssRelatedToHtmlFilesContributor", "processImports"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/navigation/CssRelatedToHtmlFilesContributor", "processImports"));
        }
        for (CssImport anImport : stylesheet.getImports()) {
            PsiFile[] resolvedElements;
            for (PsiFile element : resolvedElements = anImport.resolve()) {
                ProgressIndicatorProvider.checkCanceled();
                if (!(element instanceof PsiFile)) continue;
                resultSet.add(element);
            }
        }
    }

    public String getGroupName() {
        return "CSS";
    }
}

