/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssCharset;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.actions.CssBaseElementAtCaretIntentionAction;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CssReplaceQuotesIntention
extends CssBaseElementAtCaretIntentionAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/CssReplaceQuotesIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/actions/CssReplaceQuotesIntention", "invoke"));
        }
        final CssString string = (CssString)PsiTreeUtil.getParentOfType((PsiElement)element, CssString.class);
        if (string != null) {
            String elementText = string.getText();
            int SINGLE_QUOTE = 39;
            int DOUBLE_QUOTE = 34;
            char quoteChar = StringUtil.startsWithChar((CharSequence)elementText, (char)'\"') ? (char)'\'' : '\"';
            char oldQuoteChar = quoteChar == '\'' ? (char)'\"' : '\'';
            String newStringValue = StringUtil.unquoteString((String)elementText);
            if (newStringValue.contains("\\" + oldQuoteChar)) {
                newStringValue = newStringValue.replace("\\" + oldQuoteChar, String.valueOf(oldQuoteChar));
            }
            newStringValue = newStringValue.replace(String.valueOf(quoteChar), "\\" + quoteChar);
            newStringValue = newStringValue.replace("\\\\" + oldQuoteChar, "\\" + oldQuoteChar);
            newStringValue = newStringValue.replace("\\\\" + quoteChar, "\\" + quoteChar);
            final CssString newString = CssElementFactory.getInstance((Project)project).createString(quoteChar, newStringValue, CssPsiUtil.getStylesheetLanguage((PsiElement)element));
            new WriteCommandAction(project, new PsiFile[]{element.getContainingFile()}){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/actions/CssReplaceQuotesIntention$1", "run"));
                    }
                    string.replace((PsiElement)newString);
                }
            }.execute();
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/CssReplaceQuotesIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/actions/CssReplaceQuotesIntention", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        CssString string = (CssString)PsiTreeUtil.getParentOfType((PsiElement)element, CssString.class);
        return string != null && StringUtil.isQuotedString((String)string.getText()) && PsiTreeUtil.getParentOfType((PsiElement)element, CssCharset.class) == null && PsiTreeUtil.getParentOfType((PsiElement)element, CssStylesheet.class) != null;
    }

    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message((String)"css.intentions.replace.quotes", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/CssReplaceQuotesIntention", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = CssBundle.message((String)"css.intentions.replace.quotes", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/CssReplaceQuotesIntention", "getText"));
        }
        return string;
    }
}

