/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.colors;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.actions.colors.CssConvertColorIntention;
import com.intellij.psi.css.browse.ColorDeclarationType;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.xml.util.ColorMap;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssReplaceWithColorNameIntention
extends CssConvertColorIntention {
    @Nullable
    private String myNewColorName;

    public CssReplaceWithColorNameIntention() {
        super("color name");
    }

    @Override
    @NotNull
    public String getText() {
        String string = CssBundle.message((String)"css.intentions.replace.with.color.name.text", (Object[])new Object[]{StringUtil.notNullize((String)this.myNewColorName, (String)"color name")});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/colors/CssReplaceWithColorNameIntention", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message((String)"css.intentions.replace.with.color.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/colors/CssReplaceWithColorNameIntention", "getFamilyName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String convert(@NotNull Color color, @Nullable Project project) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/actions/colors/CssReplaceWithColorNameIntention", "convert"));
        }
        String string = ColorMap.getColorNameForHexCode((String)CssPsiColorUtil.toHexColor(color));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/colors/CssReplaceWithColorNameIntention", "convert"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getNewColorTypeName(boolean withAlphaChannel) {
        if ("HEX" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/colors/CssReplaceWithColorNameIntention", "getNewColorTypeName"));
        }
        return "HEX";
    }

    @Override
    protected boolean isApplied(@NotNull ColorDeclarationType colorType, @NotNull Color color) {
        String colorName;
        if (colorType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorType", "com/intellij/psi/css/actions/colors/CssReplaceWithColorNameIntention", "isApplied"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/actions/colors/CssReplaceWithColorNameIntention", "isApplied"));
        }
        if (colorType != ColorDeclarationType.TEXTUAL && (colorName = ColorMap.getColorNameForHexCode((String)CssPsiColorUtil.toHexColor(color))) != null) {
            this.myNewColorName = colorName;
            return true;
        }
        return false;
    }
}

