/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.codeStyle;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import org.jetbrains.annotations.NotNull;

public class CssLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        CSSLanguage cSSLanguage = CSSLanguage.INSTANCE;
        if (cSSLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/codeStyle/CssLanguageCodeStyleSettingsProvider", "getLanguage"));
        }
        return cSSLanguage;
    }

    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings defaultSettings = new CommonCodeStyleSettings((Language)CSSLanguage.INSTANCE);
        defaultSettings.initIndentOptions();
        defaultSettings.LINE_COMMENT_AT_FIRST_COLUMN = false;
        defaultSettings.BLOCK_COMMENT_AT_FIRST_COLUMN = false;
        return defaultSettings;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "com/intellij/psi/css/codeStyle/CssLanguageCodeStyleSettingsProvider", "getCodeSample"));
        }
        return "body {\n    background: black;\n    color: #80c0c0\n}";
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }
}

