/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssCharset;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssImportList;
import com.intellij.psi.css.CssNamespace;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.xml.util.XmlUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssLazyStylesheet
extends LazyParseablePsiElement
implements CssStylesheet,
XmlTagChild {
    CssLazyStylesheet(CharSequence text) {
        this(text, (IElementType)CssElementTypes.CSS_LAZY_STYLESHEET);
    }

    public CssLazyStylesheet(CharSequence text, IElementType nodeType) {
        super(nodeType, text);
    }

    @NotNull
    private CssStylesheet getStylesheet() {
        CssStylesheet cssStylesheet = (CssStylesheet)ObjectUtils.notNull((Object)PsiTreeUtil.getChildOfType((PsiElement)this, CssStylesheet.class));
        if (cssStylesheet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssLazyStylesheet", "getStylesheet"));
        }
        return cssStylesheet;
    }

    @NotNull
    public CssRulesetList getRulesetList() {
        CssRulesetList cssRulesetList = this.getStylesheet().getRulesetList();
        if (cssRulesetList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssLazyStylesheet", "getRulesetList"));
        }
        return cssRulesetList;
    }

    @Nullable
    public CssImportList getImportList() {
        return this.getStylesheet().getImportList();
    }

    @NotNull
    public CssAtRule[] getAtRules() {
        CssAtRule[] cssAtRuleArray = this.getStylesheet().getAtRules();
        if (cssAtRuleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssLazyStylesheet", "getAtRules"));
        }
        return cssAtRuleArray;
    }

    @NotNull
    public CssRuleset[] getRulesets() {
        CssRuleset[] cssRulesetArray = this.getStylesheet().getRulesets();
        if (cssRulesetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssLazyStylesheet", "getRulesets"));
        }
        return cssRulesetArray;
    }

    @NotNull
    public CssNamespace[] getNamespaces() {
        CssNamespace[] cssNamespaceArray = this.getStylesheet().getNamespaces();
        if (cssNamespaceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssLazyStylesheet", "getNamespaces"));
        }
        return cssNamespaceArray;
    }

    @NotNull
    public CssRuleset[] getRulesets(boolean allMedias) {
        CssRuleset[] cssRulesetArray = this.getStylesheet().getRulesets(allMedias);
        if (cssRulesetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssLazyStylesheet", "getRulesets"));
        }
        return cssRulesetArray;
    }

    @Nullable
    public CssNamespace getNamespace(@Nullable String prefix) {
        return this.getStylesheet().getNamespace(prefix);
    }

    @NotNull
    public List<CssImport> getImports() {
        List list = this.getStylesheet().getImports();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssLazyStylesheet", "getImports"));
        }
        return list;
    }

    @NotNull
    public List<CssImport> getImports(boolean fromImportListOnly) {
        List list = this.getStylesheet().getImports(fromImportListOnly);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssLazyStylesheet", "getImports"));
        }
        return list;
    }

    public CssRuleset addRuleset(@NotNull CssRuleset ruleset) throws IncorrectOperationException {
        if (ruleset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ruleset", "com/intellij/psi/css/impl/CssLazyStylesheet", "addRuleset"));
        }
        return this.getStylesheet().addRuleset(ruleset);
    }

    @Nullable
    public CssCharset getCharset() {
        return this.getStylesheet().getCharset();
    }

    public XmlTag getParentTag() {
        PsiElement parent = this.getParent();
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        return null;
    }

    public XmlTagChild getNextSiblingInTag() {
        PsiElement nextSibling = this.getNextSibling();
        if (nextSibling instanceof XmlTagChild) {
            return (XmlTagChild)nextSibling;
        }
        return null;
    }

    public XmlTagChild getPrevSiblingInTag() {
        PsiElement prevSibling = this.getPrevSibling();
        if (prevSibling instanceof XmlTagChild) {
            return (XmlTagChild)prevSibling;
        }
        return null;
    }

    public boolean processElements(PsiElementProcessor processor, PsiElement place) {
        return XmlUtil.processXmlElements((XmlElement)this, (PsiElementProcessor)processor, (boolean)false);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/CssLazyStylesheet", "accept"));
        }
        visitor.visitElement((PsiElement)this);
    }
}

