/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssMedia;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssRulesetWrappingElement;
import com.intellij.psi.css.impl.stubs.CssStub;
import com.intellij.psi.css.impl.stubs.base.CssStubElement;
import com.intellij.psi.css.impl.stubs.base.CssStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class CssRulesetListImpl
extends CssStubElement<CssStub>
implements CssRulesetList {
    private static final CssAtRule[] EMPTY_AT_RULES = CssAtRule.EMPTY_ARRAY;

    public CssRulesetListImpl(@NotNull CssStub stub, @NotNull CssStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/css/impl/CssRulesetListImpl", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "com/intellij/psi/css/impl/CssRulesetListImpl", "<init>"));
        }
        super(stub, nodeType);
    }

    public CssRulesetListImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/css/impl/CssRulesetListImpl", "<init>"));
        }
        super(node);
    }

    @NotNull
    public CssRuleset[] getRulesets() {
        CssRuleset[] cssRulesetArray = this.getRulesets(false);
        if (cssRulesetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssRulesetListImpl", "getRulesets"));
        }
        return cssRulesetArray;
    }

    @NotNull
    public CssRuleset[] getRulesets(boolean allMedias) {
        List rulesets = PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)this, CssRuleset.class);
        for (CssMedia media : PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)this, CssMedia.class)) {
            if (!allMedias && !media.getMediaTypes().contains(CssMediaType.SCREEN)) continue;
            ContainerUtil.addAll((Collection)rulesets, (Object[])media.getRulesets());
        }
        if (this.getStub() == null) {
            for (PsiElement element : this.getChildren()) {
                if (!(element instanceof CssRulesetWrappingElement)) continue;
                ContainerUtil.addAll((Collection)rulesets, (Object[])((CssRulesetWrappingElement)element).getRulesets());
            }
        }
        CssRuleset[] cssRulesetArray = (CssRuleset[])ArrayUtil.toObjectArray((Collection)rulesets, CssRuleset.class);
        if (cssRulesetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssRulesetListImpl", "getRulesets"));
        }
        return cssRulesetArray;
    }

    @NotNull
    public CssAtRule[] getAtRules() {
        CssAtRule[] atRules = (CssAtRule[])PsiTreeUtil.getChildrenOfType((PsiElement)this, CssAtRule.class);
        CssAtRule[] cssAtRuleArray = atRules != null ? atRules : EMPTY_AT_RULES;
        if (cssAtRuleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssRulesetListImpl", "getAtRules"));
        }
        return cssAtRuleArray;
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        PsiElement token;
        if (anchor == null && (token = this.findChildByType(CssElementTypes.CSS_CDC)) != null) {
            anchor = token.getNode();
            before = Boolean.TRUE;
        }
        return super.addInternal(first, last, anchor, before);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/CssRulesetListImpl", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssRulesetList((CssRulesetList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }
}

