/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssCharset;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssImportList;
import com.intellij.psi.css.CssNamespace;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.CssCharsetImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssRulesetWrappingElement;
import com.intellij.psi.css.impl.stubs.CssImportStub;
import com.intellij.psi.css.impl.stubs.CssStub;
import com.intellij.psi.css.impl.stubs.base.CssStubElement;
import com.intellij.psi.css.impl.stubs.base.CssStubElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssStubStylesheet
extends CssStubElement<CssStub>
implements CssStylesheet {
    public CssStubStylesheet(@NotNull CssStub stub, @NotNull CssStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/css/impl/CssStubStylesheet", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "com/intellij/psi/css/impl/CssStubStylesheet", "<init>"));
        }
        super(stub, nodeType);
    }

    public CssStubStylesheet(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/css/impl/CssStubStylesheet", "<init>"));
        }
        super(node);
    }

    @NotNull
    public CssRulesetList getRulesetList() {
        CssRulesetList cssRulesetList = (CssRulesetList)ObjectUtils.notNull((Object)PsiTreeUtil.getStubChildOfType((PsiElement)this, CssRulesetList.class));
        if (cssRulesetList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssStubStylesheet", "getRulesetList"));
        }
        return cssRulesetList;
    }

    @Nullable
    public CssImportList getImportList() {
        return (CssImportList)PsiTreeUtil.getChildOfType((PsiElement)this, CssImportList.class);
    }

    @NotNull
    public CssNamespace[] getNamespaces() {
        CssNamespace[] cssNamespaceArray = (CssNamespace[])CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            for (PsiElement child = this.getFirstChild(); child != null && !(child instanceof CssRulesetList); child = child.getNextSibling()) {
                if (!(child instanceof TreeElement) || ((TreeElement)child).getElementType() != CssElementTypes.CSS_NAMESPACE_LIST) continue;
                return CachedValueProvider.Result.create((Object)PsiTreeUtil.getChildrenOfType((PsiElement)child, CssNamespace.class), (Object[])new Object[]{this});
            }
            return CachedValueProvider.Result.create((Object)CssNamespace.EMPTY_ARRAY, (Object[])new Object[]{this});
        });
        if (cssNamespaceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssStubStylesheet", "getNamespaces"));
        }
        return cssNamespaceArray;
    }

    @NotNull
    public CssAtRule[] getAtRules() {
        CssAtRule[] cssAtRuleArray = (CssAtRule[])CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            HashSet dependentStylesheets = ContainerUtil.newHashSet();
            return CachedValueProvider.Result.create((Object)this.getAtRules(dependentStylesheets), (Object[])ArrayUtil.toObjectArray((Collection)dependentStylesheets));
        });
        if (cssAtRuleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssStubStylesheet", "getAtRules"));
        }
        return cssAtRuleArray;
    }

    @NotNull
    public CssRuleset[] getRulesets() {
        CssRuleset[] cssRulesetArray = this.getRulesets(false);
        if (cssRulesetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssStubStylesheet", "getRulesets"));
        }
        return cssRulesetArray;
    }

    @NotNull
    public CssRuleset[] getRulesets(boolean allMedias) {
        if (allMedias) {
            CssRuleset[] cssRulesetArray = (CssRuleset[])CachedValuesManager.getCachedValue((PsiElement)this, () -> {
                HashSet dependentStylesheets = ContainerUtil.newHashSet();
                return CachedValueProvider.Result.create((Object)this.getRulesets(dependentStylesheets, true), (Object[])ArrayUtil.toObjectArray((Collection)dependentStylesheets));
            });
            if (cssRulesetArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssStubStylesheet", "getRulesets"));
            }
            return cssRulesetArray;
        }
        CssRuleset[] cssRulesetArray = (CssRuleset[])CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            HashSet dependentStylesheets = ContainerUtil.newHashSet();
            return CachedValueProvider.Result.create((Object)this.getRulesets(dependentStylesheets, false), (Object[])ArrayUtil.toObjectArray((Collection)dependentStylesheets));
        });
        if (cssRulesetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssStubStylesheet", "getRulesets"));
        }
        return cssRulesetArray;
    }

    @Nullable
    public CssNamespace getNamespace(@Nullable String prefix) {
        for (CssNamespace namespace : this.getNamespaces()) {
            if (!(prefix == null ? namespace.getPrefix() == null : prefix.equals(namespace.getPrefix()))) continue;
            return namespace;
        }
        return null;
    }

    private CssRuleset[] getRulesets(@NotNull Set<CssStylesheet> includedFiles, boolean allMedias) {
        if (includedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "includedFiles", "com/intellij/psi/css/impl/CssStubStylesheet", "getRulesets"));
        }
        if (includedFiles.contains((Object)this)) {
            return CssRuleset.EMPTY_ARRAY;
        }
        includedFiles.add(this);
        List collection = ContainerUtil.newSmartList();
        for (CssImport cssImport : this.getImports()) {
            PsiFile[] stylesheetFiles;
            if (!allMedias && !cssImport.isScreen()) continue;
            for (PsiFile stylesheetFile : stylesheetFiles = cssImport.resolve()) {
                CssStylesheet stylesheet;
                if (!(stylesheetFile instanceof StylesheetFile) || !((stylesheet = ((StylesheetFile)stylesheetFile).getStylesheet()) instanceof CssStubStylesheet)) continue;
                ContainerUtil.addAll((Collection)collection, (Object[])((CssStubStylesheet)stylesheet).getRulesets(includedFiles, allMedias));
            }
        }
        ContainerUtil.addAll((Collection)collection, (Object[])this.getRulesetList().getRulesets(allMedias));
        return (CssRuleset[])ArrayUtil.toObjectArray((Collection)collection, CssRuleset.class);
    }

    private CssAtRule[] getAtRules(@NotNull Set<CssStylesheet> includedFiles) {
        if (includedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "includedFiles", "com/intellij/psi/css/impl/CssStubStylesheet", "getAtRules"));
        }
        if (includedFiles.contains((Object)this)) {
            return CssAtRule.EMPTY_ARRAY;
        }
        includedFiles.add(this);
        ArrayList atRules = ContainerUtil.newArrayList();
        for (CssImport cssImport : this.getImports()) {
            PsiFile[] stylesheetFiles;
            if (!cssImport.isScreen()) continue;
            for (PsiFile stylesheetFile : stylesheetFiles = cssImport.resolve()) {
                CssStylesheet stylesheet;
                if (!(stylesheetFile instanceof StylesheetFile) || !((stylesheet = ((StylesheetFile)stylesheetFile).getStylesheet()) instanceof CssStubStylesheet)) continue;
                CssAtRule[] importedAtRules = ((CssStubStylesheet)stylesheet).getAtRules(includedFiles);
                Collections.addAll(atRules, importedAtRules);
            }
        }
        Collections.addAll(atRules, this.getRulesetList().getAtRules());
        return (CssAtRule[])ArrayUtil.toObjectArray((Collection)atRules, CssAtRule.class);
    }

    @NotNull
    public List<CssImport> getImports() {
        List<CssImport> list = this.getImports(true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssStubStylesheet", "getImports"));
        }
        return list;
    }

    @NotNull
    public List<CssImport> getImports(boolean fromImportListOnly) {
        if (fromImportListOnly) {
            CssStub stub = (CssStub)this.getStub();
            if (stub != null) {
                List result = ContainerUtil.newSmartList();
                for (Object o : stub.getChildrenStubs()) {
                    if (!(o instanceof CssImportStub) || !((CssImportStub)((Object)o)).isFromImportList()) continue;
                    result.add(((CssImportStub)((Object)o)).getPsi());
                }
                List list = result;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssStubStylesheet", "getImports"));
                }
                return list;
            }
            CssImportList importList = this.getImportList();
            List list = importList != null ? importList.getImports() : Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssStubStylesheet", "getImports"));
            }
            return list;
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            CssStub stub = (CssStub)this.getStub();
            if (stub != null) {
                List result = ContainerUtil.newSmartList();
                CssStubStylesheet.collectAllStubImports((StubElement)stub, result);
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{this});
            }
            return CachedValueProvider.Result.create(this.collectAllImports(), (Object[])new Object[]{this});
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssStubStylesheet", "getImports"));
        }
        return list;
    }

    private static void collectAllStubImports(@NotNull StubElement stub, @NotNull List<CssImport> result) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/css/impl/CssStubStylesheet", "collectAllStubImports"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/impl/CssStubStylesheet", "collectAllStubImports"));
        }
        for (Object o : stub.getChildrenStubs()) {
            if (o instanceof CssImportStub) {
                result.add((CssImport)((CssImportStub)((Object)o)).getPsi());
                continue;
            }
            if (!(o instanceof StubElement)) continue;
            CssStubStylesheet.collectAllStubImports((StubElement)o, result);
        }
    }

    private List<CssImport> collectAllImports() {
        final ArrayList<CssImport> result = new ArrayList<CssImport>();
        this.accept((PsiElementVisitor)new CssElementVisitor(){

            public void visitCssImport(CssImport _import) {
                result.add(_import);
            }

            public void visitElement(PsiElement element) {
                element.acceptChildren((PsiElementVisitor)this);
            }
        });
        return result;
    }

    public CssRuleset addRuleset(@NotNull CssRuleset ruleset) throws IncorrectOperationException {
        PsiElement psiElement;
        if (ruleset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ruleset", "com/intellij/psi/css/impl/CssStubStylesheet", "addRuleset"));
        }
        PsiElement wrapper = ruleset.getParent();
        if (wrapper != null && wrapper instanceof CssRulesetWrappingElement && ((CssRulesetWrappingElement)wrapper).getRulesets().length == 1) {
            CssRulesetWrappingElement newWrapper = (CssRulesetWrappingElement)this.getRulesetList().add(wrapper);
            psiElement = (PsiElement)ArrayUtil.getFirstElement((Object[])newWrapper.getRulesets());
        } else {
            psiElement = this.getRulesetList().add((PsiElement)ruleset);
        }
        return (CssRuleset)psiElement;
    }

    @Nullable
    public CssCharset getCharset() {
        return (CssCharset)PsiTreeUtil.getChildOfType((PsiElement)this, CssCharsetImpl.class);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/CssStubStylesheet", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssStylesheet((CssStylesheet)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }
}

